package com.xdja.pki.oer.gbt.asn1.utils;

import com.xdja.pki.oer.gbt.asn1.EccCurve;
import com.xdja.pki.oer.gbt.asn1.utils.enums.EccCurveTypeEnum;
import org.bouncycastle.util.BigIntegers;

import java.math.BigInteger;

/**
 * @ClassName EccCurveHolder
 * @Description TODO
 * @Date 2020/1/2 10:55
 * @Author FengZhen
 */
public class EccCurveHolder {
    public static EccCurveTypeEnum build(byte[] data) throws Exception {
        EccCurve eccCurve = EccCurve.getInstance(data);
        BigInteger choice = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        if (choice.intValue() == 0) {
            return EccCurveTypeEnum.SGD_SM2;
        } else if (choice.intValue() == 1) {
            return EccCurveTypeEnum.NIST_P_256;
        } else if (choice.intValue() == 2) {
            return EccCurveTypeEnum.BRAINPOOL_P_256_R1;
        }
        return null;
    }
}
