package com.xdja.pki.oer.gbt.asn1.utils;

import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.core.ByteArrayUtils;
import com.xdja.pki.oer.gbt.asn1.EccPoint;
import com.xdja.pki.oer.gbt.asn1.Uncompressed;
import com.xdja.pki.oer.gbt.asn1.utils.enums.EccPointTypeEnum;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;

public class EccPointBuilder {

    public static EccPoint build(PublicKey publicKey, EccPointTypeEnum eccPointType) throws Exception {
        if (eccPointType == EccPointTypeEnum.UNCOMPRESSED) {
            return buildWithUnCompressed(publicKey);
        } else if (eccPointType == EccPointTypeEnum.COMPRESSED_Y || eccPointType == EccPointTypeEnum.COMPRESSED_Y0 || eccPointType == EccPointTypeEnum.COMPRESSED_Y1) {
            return buildWithCompressed(publicKey);
        } else if (eccPointType == EccPointTypeEnum.X_ONLY) {

        } else if (eccPointType == EccPointTypeEnum.FILL) {

        } else {
            throw new Exception("unsupported this eccpoint type id =  " + eccPointType.id + " value = " + eccPointType.value);
        }
        return null;
    }

    private static EccPoint buildWithUnCompressed(PublicKey publicKey) throws Exception {
        EccPoint eccPoint = new EccPoint();
        Uncompressed uncompressed = new Uncompressed();
        ECPublicKey ecPublicKey = (ECPublicKey) publicKey;
        byte[] x = ByteArrayUtils.changeByteArrayLength(ecPublicKey.getW().getAffineX());
        byte[] y = ByteArrayUtils.changeByteArrayLength(ecPublicKey.getW().getAffineY());
        uncompressed.setX(x);
        uncompressed.setY(y);
        eccPoint.setUncompressed(uncompressed);
        return eccPoint;
    }


    private static EccPoint buildWithCompressed(PublicKey publicKey) throws Exception {
        EccPoint eccPoint = new EccPoint();
        OctetString compressed = new OctetString();
        ECPublicKey ecPublicKey = (ECPublicKey) publicKey;
        byte[] x = ByteArrayUtils.changeByteArrayLength(ecPublicKey.getW().getAffineX());
        BigInteger y = ecPublicKey.getW().getAffineY();
        compressed.setString(x);
        compressed.setLength(32);
        if (y.testBit(0)) {
            //奇数
            eccPoint.setCompressedY1(compressed);
        } else {
            //偶数'
            eccPoint.setCompressedY0(compressed);
        }
        //ByteArrayUtils.printHexBinary(5, "compressed ", x);

        return eccPoint;
    }

}
