package com.xdja.pki.oer.gbt.asn1.utils;

import com.xdja.pki.oer.core.BCUtils;
import com.xdja.pki.oer.gbt.asn1.EccCurve;
import com.xdja.pki.oer.gbt.asn1.EccPoint;
import com.xdja.pki.oer.gbt.asn1.Uncompressed;
import com.xdja.pki.oer.gbt.asn1.utils.bean.OEREccPoint;
import com.xdja.pki.oer.gbt.asn1.utils.enums.EccCurveTypeEnum;
import com.xdja.pki.oer.gbt.asn1.utils.enums.EccPointTypeEnum;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.security.PublicKey;

/**
 * EccPoint解析
 */
// TODO: 2020/2/19 需要进行检查那个使用并进行更改
public class EccPointHolder {
    public static final String ECC_SM2_NAME = "sm2p256v1";
    public static final String BRAINPOOL_P_256_R1 = "brainpoolP256r1";
    public static final String NIST_P_256 = "secp256r1";
    private static Logger logger = LoggerFactory.getLogger(EccPointHolder.class);


    public static OEREccPoint build(byte[] data) throws Exception {
        return build(data, EccCurveTypeEnum.SGD_SM2);
    }

    public static OEREccPoint build(byte[] data, EccCurve eccCurve) throws Exception {
        if (eccCurve.readValue().getIndex() == EccCurve.BRAINPOOL_P_256_R1.getIndex()) {
            return build(data, EccCurveTypeEnum.BRAINPOOL_P_256_R1);
        } else if (eccCurve.readValue().getIndex() == EccCurve.NIST_P_256.getIndex()) {
            return build(data, EccCurveTypeEnum.NIST_P_256);
        } else {
            return build(data, EccCurveTypeEnum.SGD_SM2);
        }
    }

    public static OEREccPoint build(byte[] data, EccCurveTypeEnum curveTypeEnum) throws Exception {
        EccPoint eccPoint = EccPoint.getInstance(data);
        BigInteger choice = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        OEREccPoint oerEccPoint = new OEREccPoint();
        if (choice.intValue() - 0x80 == 0) {
          //  logger.debug("EccPoint choice xOnly");
        } else if (choice.intValue() - 0x80 == 1) {
           // logger.debug("EccPoint choice fill");
        } else if (choice.intValue() - 0x80 == 2) {
            //y为偶数
          //  logger.debug("EccPoint choice compressedY0");
            oerEccPoint.setEccPointType(EccPointTypeEnum.COMPRESSED_Y0);
            oerEccPoint.setPublicKey(ECPublicUtils.decodePoint(false, eccPoint.getCompressedY0().getString(), curveTypeEnum));
            oerEccPoint.setPublicKeyStr(Hex.toHexString(eccPoint.getCompressedY0().getString()));
            return oerEccPoint;
        } else if (choice.intValue() - 0x80 == 3) {
            //y为奇数
          //  logger.debug("EccPoint choice compressedY1");
            oerEccPoint.setEccPointType(EccPointTypeEnum.COMPRESSED_Y1);
            oerEccPoint.setPublicKey(ECPublicUtils.decodePoint(true, eccPoint.getCompressedY1().getString(), curveTypeEnum));
            oerEccPoint.setPublicKeyStr(Hex.toHexString(eccPoint.getCompressedY1().getString()));
            return oerEccPoint;
        } else if (choice.intValue() - 0x80 == 4) {
           // logger.debug("EccPoint choice Uncompressed");
            oerEccPoint.setEccPointType(EccPointTypeEnum.UNCOMPRESSED);
            oerEccPoint.setPublicKey(getUncompressed(eccPoint.getUncompressed(), curveTypeEnum));
            oerEccPoint.setPublicKeyStr(Hex.toHexString(eccPoint.getUncompressed().getEncode()));
            return oerEccPoint;
        } else {
          //  logger.error("EccPoint choice is error " + choice.intValue());
            throw new Exception("unsupported this eccpoint type id =  " + choice.intValue());
        }
        return null;
    }

    private static PublicKey getUncompressed(Uncompressed uncompressed, EccCurveTypeEnum curveTypeEnum) throws Exception {
        byte[] x = uncompressed.getX().getString();
        byte[] y = uncompressed.getY().getString();
        if (curveTypeEnum == EccCurveTypeEnum.SGD_SM2) {
            return BCUtils.convertSM2PublicKey(BigIntegers.fromUnsignedByteArray(x), BigIntegers.fromUnsignedByteArray(y));
        } else if (curveTypeEnum == EccCurveTypeEnum.NIST_P_256) {
            return BCUtils.convertNISTPPublicKey(BigIntegers.fromUnsignedByteArray(x), BigIntegers.fromUnsignedByteArray(y));
        } else {
            return BCUtils.convertBRAINPOOLPublicKey(BigIntegers.fromUnsignedByteArray(x), BigIntegers.fromUnsignedByteArray(y));
        }

    }

}
