package com.xdja.pki.oer.gbt.asn1.utils;

import com.xdja.pki.oer.core.ButterFlyKeyUtils;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;

import java.math.BigInteger;


/**
 * 获取显式公钥和重构值
 */
public class ExplicitCertPublicUtils {
    /**
     * 获取返回重构值
     *
     * @param s CA系统随机生成的密钥对对应的私钥值
     * @return BigInteger 私钥重构值
     */
    public static BigInteger buildReconstructionValue(ECPrivateKey s) throws Exception {
        return s.getD();
    }

    /**
     * 获取显式证书的公钥
     *
     * @param S CA系统随机生成的密钥对对应的公钥值
     * @param B 传输过来的公钥值
     * @return ECPublicKey 显式证书的公钥
     */
    public static ECPublicKey buildReconstructionPublicKey(ECPublicKey S, ECPublicKey B) throws Exception {
        return ButterFlyKeyUtils.addECPublic(S, B);
    }

    /**
     * 获取显式证书的私钥
     *
     * @param s           CA系统返回的私钥重构值
     * @param bPrivateKey 传输前的私钥
     * @return ECPrivateKey 显式证书的私钥
     */
    public static ECPrivateKey buildEcPrivateKey(BigInteger s, ECPrivateKey bPrivateKey) throws Exception {
        return ButterFlyKeyUtils.addPrivateKey(s, bPrivateKey);
    }
}
