package com.xdja.pki.oer.gbt.asn1.utils;

import com.xdja.pki.gmssl.asn1.crypto.ASN1SM2Cipher;
import com.xdja.pki.oer.core.ByteArrayUtils;
import com.xdja.pki.oer.core.calculate.CalculateFactory;
import com.xdja.pki.oer.core.calculate.CalculateService;
import com.xdja.pki.oer.gbt.asn1.EccCurve;
import com.xdja.pki.oer.gbt.asn1.EccPoint;
import com.xdja.pki.oer.gbt.asn1.EciesEncryptedKey;
import com.xdja.pki.oer.gbt.asn1.Uncompressed;
import com.xdja.pki.oer.gbt.asn1.utils.enums.EccCurveTypeEnum;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Curve;
import org.bouncycastle.math.ec.custom.sec.SecP256R1Curve;

import java.security.PublicKey;
import java.util.Objects;

/**
 * @ClassName KekBuilder
 */
public class KekBuilder {
    private static CalculateService calculateService = CalculateFactory.getInstance();
    public static EciesEncryptedKey build(EccPoint eccPoint, byte[] key) throws Exception {
        PublicKey publicKey = Objects.requireNonNull(EccPointHolder.build(eccPoint.getEncode())).getPublicKey();
        return build(publicKey, key);
    }

    public static EciesEncryptedKey build(EccPoint eccPoint, byte[] key, EccCurveTypeEnum typeEnum) throws Exception {
        PublicKey publicKey = Objects.requireNonNull(EccPointHolder.build(eccPoint.getEncode(), typeEnum)).getPublicKey();
        return build(publicKey, key);
    }

    public static EciesEncryptedKey build(PublicKey publicKey, byte[] key) throws Exception {
        //todo NIST
        ASN1SM2Cipher asn1SM2Cipher;
        EciesEncryptedKey kek = new EciesEncryptedKey();
        ECCurve eccCurve = ((BCECPublicKey) publicKey).getParameters().getCurve();
        if (eccCurve instanceof SM2P256V1Curve) {
            //byte[] cipher = GMSSLSM2EncryptUtils.encryptASN1BySdf(SdfCryptoType.YUNHSM, publicKey, key, 0, key.length);
            byte[] cipher =calculateService.sm2EncryptAsn1(publicKey,key);
            asn1SM2Cipher = ASN1SM2Cipher.getInstance(cipher);
            kek.setEccCurve(new EccCurve(EccCurve.SGD_SM2));
        } else if (eccCurve instanceof SecP256R1Curve) {
           // byte[] cipher = GMSSLECIESEncryptUtils.encrypt(GMSSLCryptoType.YUNHSM, publicKey, key);
            byte[] cipher =calculateService.eciesEncrypt(publicKey,key);
            asn1SM2Cipher = ASN1SM2Cipher.convertToASN1(new SecP256R1Curve(), cipher, new SHA256Digest().getDigestSize());
            kek.setEccCurve(new EccCurve(EccCurve.NIST_P_256));
        } else {
            throw new Exception("不支持的曲线类型 ： " + eccCurve);
        }
        EccPoint v = new EccPoint();
        Uncompressed vu = new Uncompressed();
        vu.setX(ByteArrayUtils.changeByteArrayLength(asn1SM2Cipher.getxCoordinate()));
        vu.setY(ByteArrayUtils.changeByteArrayLength(asn1SM2Cipher.getyCoordinate()));
        v.setUncompressed(vu);
        kek.setV(v);
        kek.setC(asn1SM2Cipher.getCipherText());
        kek.setT(asn1SM2Cipher.getHash());
        return kek;
    }
}
