package com.xdja.pki.oer.gbt.asn1.utils;

import com.xdja.pki.gmssl.asn1.crypto.ASN1SM2Cipher;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECIESEncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2EncryptUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.core.ByteArrayUtils;
import com.xdja.pki.oer.core.calculate.CalculateFactory;
import com.xdja.pki.oer.core.calculate.CalculateService;
import com.xdja.pki.oer.gbt.asn1.EccCurve;
import com.xdja.pki.oer.gbt.asn1.EccPoint;
import com.xdja.pki.oer.gbt.asn1.EciesEncryptedKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.PrivateKey;

/**
 * @ClassName KekResolveUtils
 */
public class KekResolveUtils {
    private static Logger logger = LoggerFactory.getLogger(KekResolveUtils.class);
    private static CalculateService calculateService = CalculateFactory.getInstance();

    public static byte[] getPlain(EciesEncryptedKey kek, PrivateKey privateKey) throws Exception {
        EccPoint v = kek.getV();
        OctetString x = v.getUncompressed().getX();
        byte[] datass = new byte[32 + 32 + 32 + 16];
        System.arraycopy(x.getString(), 0, datass, 0, x.getString().length);
        OctetString y = v.getUncompressed().getY();
        System.arraycopy(y.getString(), 0, datass, 32, y.getString().length);
        System.arraycopy(kek.getT().getString(), 0, datass, 32 + 32, kek.getT().getString().length);
        System.arraycopy(kek.getC().getString(), 0, datass, 32 + 32 + 32, kek.getC().getString().length);
        ASN1SM2Cipher asn1SM2Cipher = new ASN1SM2Cipher(x.getString(), y.getString(), kek.getT().getString(), kek.getC().getString());
        if (kek.getEccCurve().readValue().getIndex() == EccCurve.SGD_SM2.getIndex()) {
            if (privateKey instanceof SdfPrivateKey) {
                return GMSSLSM2EncryptUtils.decryptASN1BySdf(SdfCryptoType.YUNHSM, ((SdfPrivateKey) privateKey).getIndex(),
                        new String(((SdfPrivateKey) privateKey).getPassword()), asn1SM2Cipher.getEncoded(), 0, asn1SM2Cipher.getEncoded().length);
            } else {
                return GMSSLSM2EncryptUtils.decryptASN1ByBC(privateKey, asn1SM2Cipher.getEncoded());
            }
            //    return calculateService.sm2Decrypt(privateKey, asn1SM2Cipher.getEncoded());
        } else if (kek.getEccCurve().readValue().getIndex() == EccCurve.NIST_P_256.getIndex()) {
            byte[] cipher = ASN1SM2Cipher.pieceC1C2C3(ByteArrayUtils.changeByteArrayLength(asn1SM2Cipher.getxCoordinate()),
                    ByteArrayUtils.changeByteArrayLength(asn1SM2Cipher.getyCoordinate()),
                    asn1SM2Cipher.getHash(),
                    asn1SM2Cipher.getCipherText());
            if (privateKey instanceof SdfPrivateKey) {
                return GMSSLECIESEncryptUtils.decrypt(GMSSLCryptoType.YUNHSM, privateKey, cipher);
            } else {
                return GMSSLECIESEncryptUtils.decrypt(GMSSLCryptoType.BC, privateKey, cipher);
            }
//            return calculateService.eciesDecrypt(privateKey, cipher);
        } else {
            throw new Exception("不支持的曲线类型 ：" + kek.getEccCurve().readValue().getIndex());
        }
    }
}
