package com.xdja.pki.oer.gbt.asn1.utils;

import com.xdja.pki.oer.gbt.asn1.Latitude;
import com.xdja.pki.oer.gbt.asn1.Longitude;
import com.xdja.pki.oer.gbt.asn1.RectangularRegion;
import com.xdja.pki.oer.gbt.asn1.TwoDLocation;

public class RectangularRegionBuilder {

    /**
     * 构造 四边形区域
     * @param northWestLatitude 北 西 维度
     * @param northWestLongitude 北 西 经度
     * @param southEastLatitude 南 东 纬度
     * @param southEastLongitude 南 东 经度
     * @return 四边形区域信息
     */
    public RectangularRegion build(
            int northWestLatitude,
            int northWestLongitude,
            int southEastLatitude,
            int southEastLongitude
    ) {
        RectangularRegion rectangularRegion = new RectangularRegion();
        // 北 西
        TwoDLocation northWest = new TwoDLocation();
        // 纬度
        northWest.setLatitude(new Latitude(northWestLatitude));
        // 经度
        northWest.setLongitude(new Longitude(northWestLongitude));
        rectangularRegion.setNorthWest(northWest);

        // 南 东
        TwoDLocation southEast = new TwoDLocation();
        // 纬度
        southEast.setLatitude(new Latitude(southEastLatitude));
        // 经度
        southEast.setLongitude(new Longitude(southEastLongitude));
        rectangularRegion.setSouthEast(southEast);
        return rectangularRegion;
    }

}
