package com.xdja.pki.oer.gbt.asn1.utils;

import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.oer.base.Null;
import com.xdja.pki.oer.core.ByteArrayUtils;
import com.xdja.pki.oer.core.TimeUtils;
import com.xdja.pki.oer.core.calculate.CalculateFactory;
import com.xdja.pki.oer.core.calculate.CalculateService;
import com.xdja.pki.oer.gbt.asn1.*;
import org.bouncycastle.util.BigIntegers;

import java.math.BigInteger;


public class SecureMessageUtils {
    public static CalculateService calculateService = CalculateFactory.getInstance();

    public static SecuredMessage buildSignSecuredMessage(Certificate signCert, HashAlgorithm hashAlgorithm, ItsAidInt aidInt, int privateKeyIndex, String privateKeyPassword, byte[] data) throws Exception {
        SecuredMessage securedMessage = new SecuredMessage();
        SignedData signedData = new SignedData();
        SignerInfo signerInfo;
        if (null == signCert) {
            signerInfo = new SignerInfo(new Null());
        } else {
            SequenceOfCertificate certs = new SequenceOfCertificate();
            certs.addCertificate(signCert);
            signerInfo = new SignerInfo(certs);
        }
        TBSData tbsData = new TBSData();
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setItsAid(aidInt);
        headerInfo.setGenTime(new Time64(TimeUtils.getNowTime() * 1000));
        headerInfo.setHashAlg(hashAlgorithm);
        tbsData.setHeaderInfo(headerInfo);
        tbsData.setData(data);
        byte[] signData;
        if (null == signCert) {
            signData = buildSignData(tbsData.getEncode(), null, hashAlgorithm);
        } else {
            signData = buildSignData(tbsData.getEncode(), signCert, hashAlgorithm);
        }

        Signature signature = SignatureBuilder.build(new SdfPrivateKey(privateKeyIndex, privateKeyPassword.getBytes()), signData);
        signedData.setSignerInfo(signerInfo);
        signedData.setTbs(tbsData);
        signedData.setSign(signature);
        Payload payload = new Payload(signedData);
        securedMessage.setPayload(payload);
        return securedMessage;
    }

    private static byte[] buildSignData(byte[] data, Certificate signCert, HashAlgorithm hashAlgorithm) throws Exception {
        byte[] tbsHash = calculateService.sm3Hash(data);
        BigInteger choice = BigIntegers.fromUnsignedByteArray(hashAlgorithm.getEncode(), 0, 1);
        if (choice.intValue() == HashAlgorithm.SGD_SM3.getIndex()) {
            if (null == signCert) {
                byte[] nullHash = calculateService.sm3Hash("".getBytes());
                return ByteArrayUtils.buildUpByte(tbsHash, nullHash);
            } else {
                byte[] certHash = calculateService.sm3Hash(signCert.getEncode());
                return ByteArrayUtils.buildUpByte(tbsHash, certHash);
            }
        } else {
            if (null == signCert) {
                byte[] nullHash = calculateService.sha256Hash("".getBytes());
                return ByteArrayUtils.buildUpByte(tbsHash, nullHash);
            } else {
                byte[] certHash = calculateService.sha256Hash(signCert.getEncode());
                return ByteArrayUtils.buildUpByte(tbsHash, certHash);
            }
        }
    }
}
