package com.xdja.pki.oer.gbt.asn1.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLBCSignUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECSignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import com.xdja.pki.oer.base.OERObject;
import com.xdja.pki.oer.core.BCUtils;
import com.xdja.pki.oer.core.calculate.CalculateFactory;
import com.xdja.pki.oer.core.calculate.CalculateService;
import com.xdja.pki.oer.gbt.asn1.EccCurve;
import com.xdja.pki.oer.gbt.asn1.Signature;
import com.xdja.pki.oer.gbt.asn1.utils.enums.EccCurveTypeEnum;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Curve;
import org.bouncycastle.math.ec.custom.sec.SecP256R1Curve;

import java.security.PrivateKey;


public class SignatureBuilder {
    //private static CalculateService calculateService = CalculateFactory.getInstance();

    public static Signature build(PrivateKey privateKey, OERObject tobeSign) throws Exception {
        return build(privateKey, tobeSign.getEncode());
    }

    public static Signature build(PrivateKey privateKey, byte[] data) throws Exception {
        return build(privateKey, data, EccCurveTypeEnum.SGD_SM2);
    }

    public static Signature build(PrivateKey privateKey, byte[] data, EccCurveTypeEnum eccCurveTypeEnum) throws Exception {
        byte[] r;
        byte[] s;
        EccCurve eccCurve;
        try {
            byte[] sign;
            if (privateKey instanceof SdfPrivateKey) {
                if (eccCurveTypeEnum == EccCurveTypeEnum.SGD_SM2) {
                    sign = GMSSLSM2SignUtils.signBySdfWithUserId(SdfCryptoType.YUNHSM,
                            ((SdfPrivateKey) privateKey).getIndex(),
                            new String(((SdfPrivateKey) privateKey).getPassword()),
                            "China".getBytes(),
                            data);
                    //          sign = calculateService.sm2SignWithUserId(privateKey, data);
                    eccCurve = new EccCurve(EccCurve.SGD_SM2);
                } else if (eccCurveTypeEnum == EccCurveTypeEnum.NIST_P_256) {
                    sign = GMSSLECSignUtils.signByYunHsm(((SdfPrivateKey) privateKey).getIndex(),
                            new String(((SdfPrivateKey) privateKey).getPassword()), data, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName());
                    // sign = calculateService.ecdsaSign(privateKey, data);
                    eccCurve = new EccCurve(EccCurve.NIST_P_256);
                } else {
                    throw new Exception("暂不支持该曲线 " + eccCurveTypeEnum);
                }
            } else {
                BCECPrivateKey key = (BCECPrivateKey) privateKey;
                if (key.getParameters().getCurve() instanceof SM2P256V1Curve) {
                    CalculateService calculateService = CalculateFactory.getInstance(CalculateFactory.CalculateType.BC);
                    sign = calculateService.sm2SignWithUserId(privateKey, data);
                    eccCurve = new EccCurve(EccCurve.SGD_SM2);
                } else if (key.getParameters().getCurve() instanceof SecP256R1Curve) {
                    //nist
                    sign = GMSSLBCSignUtils.generateSignature(
                            GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(),
                            privateKey, data);
                    eccCurve = new EccCurve(EccCurve.NIST_P_256);
                } else {
                    throw new Exception("暂不支持该曲线类型 " + key.getParameters().getCurve());
                }
            }
            byte[][] derDecode = BCUtils.sm2SignDerDecode(sign);
            assert derDecode != null && derDecode.length == 2;
            r = derDecode[0];
            s = derDecode[1];
        } catch (Exception e) {
            throw new Exception(e);
        }
        //ByteArrayUtils.printHexBinary(3, "Signature", null);
        Signature signature = new Signature();
        signature.setEccCurve(eccCurve);
        signature.setR(r);
        //ByteArrayUtils.printHexBinary(4, "r", r);
        signature.setS(s);
        //ByteArrayUtils.printHexBinary(4, "s", s);
        return signature;
    }


}
