package com.xdja.pki.oer.gbt.asn1.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.oer.core.BCUtils;
import com.xdja.pki.oer.core.calculate.CalculateFactory;
import com.xdja.pki.oer.core.calculate.CalculateService;
import com.xdja.pki.oer.gbt.asn1.Signature;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Curve;

import java.io.IOException;
import java.security.PublicKey;


public class SignatureVerify {
    public static CalculateService calculateService = CalculateFactory.getInstance();

    public static boolean verify(PublicKey publicKey, byte[] data, Signature signature) throws IOException {
        byte[] r = signature.getR().getxOnly().getString();
        byte[] s = signature.getS().getString();
        GMSSLByteArrayUtils.printHexBinary(null, "r", r);
        GMSSLByteArrayUtils.printHexBinary(null, "s", s);
        GMSSLByteArrayUtils.printHexBinary(null, "sign content", data);
        byte[] sign = BCUtils.sm2SignDerEncode(r, s);
        if (((BCECPublicKey) publicKey).getParameters().getCurve() instanceof SM2P256V1Curve) {
            try {
                //   return GMSSLSM2SignUtils.verifyBySdfWithUserId(SdfCryptoType.YUNHSM, publicKey, "China".getBytes(), data, sign);
                return calculateService.sm2VerifyWithUserId(publicKey, data, sign);
            } catch (Exception e) {
                return false;
            }
        } else {
            //todo  NISTP
            try {
                //   return GMSSLBCSignUtils.verifySignature(GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), publicKey, data, sign);
                return calculateService.ecdsaVerify(publicKey, data, sign);
            } catch (Exception e) {
                return false;
            }
        }

    }

}
