package com.xdja.pki.oer.gbt.asn1.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.oer.base.Int;
import com.xdja.pki.oer.core.BCUtils;
import com.xdja.pki.oer.core.calculate.CalculateFactory;
import com.xdja.pki.oer.core.calculate.CalculateService;
import com.xdja.pki.oer.gbt.asn1.*;
import com.xdja.pki.oer.gbt.asn1.utils.bean.OERCertificate;
import com.xdja.pki.oer.gbt.asn1.utils.bean.OERSignedData;
import org.bouncycastle.util.BigIntegers;

import java.math.BigInteger;
import java.util.List;

/**
 * @ClassName SignedDataHolder
 */
public class SignedDataHolder {
    public static CalculateService calculateService = CalculateFactory.getInstance();

    public static OERSignedData build(byte[] data) throws Exception {
        SignedData signedData = SignedData.getInstance(data);
        SignerInfo signerInfo = signedData.getSignerInfo();
        OERSignedData oerSignedData = new OERSignedData();
        byte[] encode = signerInfo.getEncode();
        if (BigIntegers.fromUnsignedByteArray(encode, 0, 1).intValue() == 0x81) {
            List<Certificate> certificates = signerInfo.getCertificate().getCertificates();
            for (int i = 0; i < certificates.size(); i++) {
                OERCertificate certificate = CertificateHolder.build(certificates.get(i).getEncode());
                System.out.println(certificate);
                oerSignedData.setCertificate(certificate);
            }
        } else if (BigIntegers.fromUnsignedByteArray(encode, 0, 1).intValue() == 0x82) {
            HashedId8 hashedId8 = signerInfo.getCertificateDigest().getHashedId8();
            oerSignedData.setSignerHashId8(GMSSLByteArrayUtils.hexEncode(hashedId8.getString()));
        } else {
            byte[] bytes = calculateService.sm3Hash(signedData.getTbs().getEncode());
            byte[] goal = new byte[8];
            System.arraycopy(bytes, data.length - 8, goal, 0, goal.length);
            oerSignedData.setSignerHashId8(GMSSLByteArrayUtils.hexEncode(goal));
        }
        TBSData tbsData = signedData.getTbs();
        oerSignedData.setData(tbsData.getData().getEncode());
        Int itsAid = tbsData.getHeaderInfo().getItsAid();
        int value = itsAid.getValue();
        oerSignedData.setItsAid(value);
        HashAlgorithm hashAlg = tbsData.getHeaderInfo().getHashAlg();
        BigInteger choice = BigIntegers.fromUnsignedByteArray(hashAlg.getEncode(), 0, 1);
        if (choice.intValue() == 0) {
            oerSignedData.setHashAlg("SGD_SM3");
        } else {
            oerSignedData.setHashAlg("SHA_256");
        }
        Signature sign = signedData.getSign();
        byte[] r = sign.getR().getxOnly().getString();
        byte[] s = sign.getS().getString();
        byte[] signature = BCUtils.sm2SignDerEncode(r, s);
        oerSignedData.setSignature(signature);
        return oerSignedData;
    }

}
