package com.xdja.pki.oer.gbt.asn1.utils;

import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.core.TimeUtils;
import com.xdja.pki.oer.gbt.asn1.*;
import com.xdja.pki.oer.gbt.asn1.utils.bean.*;
import com.xdja.pki.oer.gbt.asn1.utils.enums.BATCSubjectTypeEnum;
import com.xdja.pki.oer.gbt.asn1.utils.enums.GeographicRegionTypeEnum;
import com.xdja.pki.oer.gbt.asn1.utils.enums.SubjectTypeEnum;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

import java.math.BigInteger;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;

/**
 * 获取TBSCert详情
 */
public class TbsCertHolder {
    public static OERTbsCert build(byte[] data) throws Exception {
        TbsCert tbsCert = TbsCert.getInstance(data);
        return build(tbsCert);
    }

    public static OERTbsCert build(TbsCert tbsCert) throws Exception {
        OctetString subject = tbsCert.getSubjectInfo().getSubjectName();
        String subjectName = new String(subject.getString());
        PublicVerifyKey verifyKey = tbsCert.getSubjectAttribute().getVerifyKey();
        OERTbsCert oerTbsCert = new OERTbsCert();
        OEREccPoint oerSignEccPoint = EccPointHolder.build(verifyKey.getEccPoint().getEncode(), verifyKey.getEccCurve());
        PublicKey signPublicKey = oerSignEccPoint.getPublicKey();
        oerTbsCert.setSignPublicKeyStr(oerSignEccPoint.getPublicKeyStr());
        oerTbsCert.setSignEccPointType(oerSignEccPoint.getEccPointType());
        SubjectType subjectType = tbsCert.getSubjectInfo().getSubjectType();
        BigInteger type = BigIntegers.fromUnsignedByteArray(subjectType.getEncode());
        String subType = "";
        switch (type.intValue()) {
            case 0:
                subType = SubjectTypeEnum.ENROLLMENT_CREDENTIAL.value;
                oerTbsCert.setType(SubjectTypeEnum.ENROLLMENT_CREDENTIAL);
                oerTbsCert.setBatcType(BATCSubjectTypeEnum.ENROLLMENT_CREDENTIAL);
                break;
            case 1:
                subType = SubjectTypeEnum.AUTHORIZATION_TICKET.value;
                oerTbsCert.setType(SubjectTypeEnum.AUTHORIZATION_TICKET);
                oerTbsCert.setBatcType(BATCSubjectTypeEnum.PSEUDONYM_CERTIFICATE);
                break;
            case 2:
                subType = SubjectTypeEnum.AUTHORIZATION_AUTHORITY.value;
                oerTbsCert.setType(SubjectTypeEnum.AUTHORIZATION_AUTHORITY);
                oerTbsCert.setBatcType(BATCSubjectTypeEnum.PSEUDONYM_AUTHORITY);
                break;
            case 3:
                subType = SubjectTypeEnum.ENROLLMENT_AUTHORITY.value;
                oerTbsCert.setType(SubjectTypeEnum.ENROLLMENT_AUTHORITY);
                oerTbsCert.setBatcType(BATCSubjectTypeEnum.ENROLLMENT_AUTHORITY);
                break;
            case 4:
                subType = SubjectTypeEnum.ROOT_CA.value;
                oerTbsCert.setType(SubjectTypeEnum.ROOT_CA);
                oerTbsCert.setBatcType(BATCSubjectTypeEnum.ROOT_CA);
                break;
            case 5:
                subType = SubjectTypeEnum.CRL_SIGNER.value;
                oerTbsCert.setType(SubjectTypeEnum.CRL_SIGNER);
                oerTbsCert.setBatcType(BATCSubjectTypeEnum.CRL_SIGNER);
                break;
            case 6:
                subType = SubjectTypeEnum.PSEUDONYM_CERTIFICATE.value;
                oerTbsCert.setType(SubjectTypeEnum.PSEUDONYM_CERTIFICATE);
                oerTbsCert.setBatcType(BATCSubjectTypeEnum.PSEUDONYM_CERTIFICATE);
                break;
            case 7:
                subType = SubjectTypeEnum.PSEUDONYM_AUTHORITY.value;
                oerTbsCert.setType(SubjectTypeEnum.PSEUDONYM_AUTHORITY);
                oerTbsCert.setBatcType(BATCSubjectTypeEnum.PSEUDONYM_AUTHORITY);
                break;
            case 8:
                subType = SubjectTypeEnum.INTERMEDIATE_AUTHORITY.value;
                oerTbsCert.setType(SubjectTypeEnum.INTERMEDIATE_AUTHORITY);
                oerTbsCert.setBatcType(BATCSubjectTypeEnum.INTERMEDIATE_AUTHORITY);
                break;
            case 9:
                subType = SubjectTypeEnum.POLICE_GENERATOR_AUTHORITY.value;
                oerTbsCert.setType(SubjectTypeEnum.POLICE_GENERATOR_AUTHORITY);
                oerTbsCert.setBatcType(BATCSubjectTypeEnum.POLICE_GENERATOR_AUTHORITY);
                break;
            default:
                throw new Exception("unknown subject type " + type.intValue());

        }
        ValidityRestriction validityRestriction = tbsCert.getValidityRestriction();
        String startTime = "";
        String endTime = "";

        if (null != validityRestriction.getValidityPeriod().getTimeEnd()) {
            Time32 timeEnd = validityRestriction.getValidityPeriod().getTimeEnd();
            BigInteger time = BigIntegers.fromUnsignedByteArray(timeEnd.getEncode());
            endTime = TimeUtils.getTime(time.longValue());
            oerTbsCert.setEndDate(TimeUtils.getTimeFromNumber(time.longValue()));
        }
        if (null != validityRestriction.getValidityPeriod().getTimeStartAndEnd()) {
            Time32 timeStart = validityRestriction.getValidityPeriod().getTimeStartAndEnd().getStartValidity();
            BigInteger sTime = BigIntegers.fromUnsignedByteArray(timeStart.getEncode());
            startTime = TimeUtils.getTime(sTime.longValue());
            oerTbsCert.setStartDate(TimeUtils.getTimeFromNumber(sTime.longValue()));
            Time32 timeEnd = validityRestriction.getValidityPeriod().getTimeStartAndEnd().getEndValidity();
            BigInteger eTime = BigIntegers.fromUnsignedByteArray(timeEnd.getEncode());
            endTime = TimeUtils.getTime(eTime.longValue());
            oerTbsCert.setEndDate(TimeUtils.getTimeFromNumber(eTime.longValue()));
        }

        try {
            List<RectangularRegion> rectangularRegions = validityRestriction.getGeographicRegion().getRectangularRegion().getRectangularRegions();
            List<OERRectangularRegion> regions = new ArrayList<>();
            for (RectangularRegion rectangularRegion : rectangularRegions) {
                OERRectangularRegion region = new OERRectangularRegion();
                region.setNorthWestLatitude(rectangularRegion.getNorthWest().getLatitude().getValue());
                region.setNorthWestLongitude(rectangularRegion.getNorthWest().getLongitude().getValue());
                region.setSouthEastLatitude(rectangularRegion.getSouthEast().getLatitude().getValue());
                region.setSouthEastLongitude(rectangularRegion.getSouthEast().getLongitude().getValue());
                regions.add(region);
            }
            oerTbsCert.setRectangularRegions(regions);
            oerTbsCert.setRegionType(GeographicRegionTypeEnum.RECTANGULAR_REGION);
        } catch (Exception e) {
            //   e.printStackTrace();
        }

        try {
            CircularRegion circularRegion = validityRestriction.getGeographicRegion().getCircularRegion();
            OERCircularRegion region = new OERCircularRegion();
            BigInteger r = BigIntegers.fromUnsignedByteArray(circularRegion.getRadius().getEncode());
            region.setR(r.intValue());
            region.setLatitude(circularRegion.getCenter().getLatitude().getValue());
            region.setLongitude(circularRegion.getCenter().getLongitude().getValue());
            oerTbsCert.setCircularRegion(region);
            oerTbsCert.setRegionType(GeographicRegionTypeEnum.CIRCULAR_REGION);
        } catch (Exception e) {
            //   e.printStackTrace();
        }

        try {
            List<TwoDLocation> twoDLocations = validityRestriction.getGeographicRegion().getPolygonalRegion().getTwoDLocations();
            List<OERPolygonalRegion> regions = new ArrayList<>();
            for (TwoDLocation twoDLocation : twoDLocations) {
                OERPolygonalRegion region = new OERPolygonalRegion();
                region.setLatitude(twoDLocation.getLatitude().getValue());
                region.setLongitude(twoDLocation.getLongitude().getValue());
                regions.add(region);
            }
            oerTbsCert.setPolygonalRegions(regions);
            oerTbsCert.setRegionType(GeographicRegionTypeEnum.POLYGONAL_REGION);
        } catch (Exception e) {
            //   e.printStackTrace();
        }

        List<String> itsAidList = new ArrayList<>();
        try {
            List<ItsAid> itsAid = tbsCert.getSubjectAttribute().getItsAidList().getItsAid();
            for (int i = 0; i < itsAid.size(); i++) {
                String s = Hex.toHexString(itsAid.get(i).getEncode());
                String aid = s.replaceAll("^(0+)", "").toUpperCase();
                itsAidList.add(aid);
            }
        } catch (Exception e) {
            //e.printStackTrace();
        }
        List<OERItsAidSsp> sspList = new ArrayList<>();
        try {
            List<ItsAidSsp> itsAidSsp = tbsCert.getSubjectAttribute().getItsSspList().getItsAidSsp();
            for (int i = 0; i < itsAidSsp.size(); i++) {
                OERItsAidSsp ssp = new OERItsAidSsp();
                List<Integer> list = itsAidSsp.get(i).getServiceSpecificPermissionsList();
                ssp.setList(list);
                ItsAid itsAid = itsAidSsp.get(i).getItsAid();
                String s = Hex.toHexString(itsAid.getEncode());
                String aid = s.replaceAll("^(0+)", "").toUpperCase();
                ssp.setItsAid(aid);
                sspList.add(ssp);
            }
        } catch (Exception e) {
            //e.printStackTrace();
        }
        try {
            PublicEncryptionKey encryptionKey = tbsCert.getSubjectAttribute().getEncryptionKey();
            OEREccPoint oerEncPoint = EccPointHolder.build(encryptionKey.getPublicKey().getEncode(), encryptionKey.getEccCurve());
            oerTbsCert.setEncPublic(oerEncPoint.getPublicKey());
            oerTbsCert.setEncEccPointType(oerEncPoint.getEccPointType());
            oerTbsCert.setEncPublicKeyStr(oerEncPoint.getPublicKeyStr());
        } catch (Exception e) {
            // e.printStackTrace();
        }
        oerTbsCert.setItsAid(itsAidList);
        oerTbsCert.setItsAidSspList(sspList);
        oerTbsCert.setSubjectType(subType);
        oerTbsCert.setStartTime(startTime);
        oerTbsCert.setEndTime(endTime);
        oerTbsCert.setSignPublicKey(signPublicKey);
        oerTbsCert.setSubjectName(subjectName);
        return oerTbsCert;
    }
}
