package com.xdja.pki.oer.gbt.asn1.utils.bean;

import com.xdja.pki.oer.gbt.asn1.utils.enums.BATCSubjectTypeEnum;
import com.xdja.pki.oer.gbt.asn1.utils.enums.EccPointTypeEnum;
import com.xdja.pki.oer.gbt.asn1.utils.enums.GeographicRegionTypeEnum;
import com.xdja.pki.oer.gbt.asn1.utils.enums.SubjectTypeEnum;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class OERTbsCert {

    private String subjectName;
    private PublicKey signPublicKey;
    private String subjectType;
    private SubjectTypeEnum type;
    private BATCSubjectTypeEnum batcType;
    private String startTime;
    private String endTime;
    private Date startDate;
    private Date endDate;
    private List<String> itsAid;
    private List<OERItsAidSsp> itsAidSspList;
    private PublicKey encPublic;
    private GeographicRegionTypeEnum regionType = GeographicRegionTypeEnum.NO_CONFIGURATION_AREA;
    private OERCircularRegion circularRegion = new OERCircularRegion();
    private List<OERRectangularRegion> rectangularRegions = new ArrayList<>();
    private List<OERPolygonalRegion> polygonalRegions = new ArrayList<>();
    private EccPointTypeEnum signEccPointType;
    private EccPointTypeEnum encEccPointType;
    private String signPublicKeyStr;
    private String encPublicKeyStr;

    public EccPointTypeEnum getSignEccPointType() {
        return signEccPointType;
    }

    public void setSignEccPointType(EccPointTypeEnum signEccPointType) {
        this.signEccPointType = signEccPointType;
    }

    public EccPointTypeEnum getEncEccPointType() {
        return encEccPointType;
    }

    public void setEncEccPointType(EccPointTypeEnum encEccPointType) {
        this.encEccPointType = encEccPointType;
    }

    public String getSignPublicKeyStr() {
        return signPublicKeyStr;
    }

    public void setSignPublicKeyStr(String signPublicKeyStr) {
        this.signPublicKeyStr = signPublicKeyStr;
    }

    public String getEncPublicKeyStr() {
        return encPublicKeyStr;
    }

    public void setEncPublicKeyStr(String encPublicKeyStr) {
        this.encPublicKeyStr = encPublicKeyStr;
    }

    public SubjectTypeEnum getType() {
        return type;
    }

    public void setType(SubjectTypeEnum type) {
        this.type = type;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public PublicKey getSignPublicKey() {
        return signPublicKey;
    }

    public void setSignPublicKey(PublicKey signPublicKey) {
        this.signPublicKey = signPublicKey;
    }

    public String getSubjectType() {
        return subjectType;
    }

    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public List<String> getItsAid() {
        return itsAid;
    }

    public void setItsAid(List<String> itsAid) {
        this.itsAid = itsAid;
    }

    public List<OERItsAidSsp> getItsAidSspList() {
        return itsAidSspList;
    }

    public void setItsAidSspList(List<OERItsAidSsp> itsAidSspList) {
        this.itsAidSspList = itsAidSspList;
    }

    public PublicKey getEncPublic() {
        return encPublic;
    }

    public void setEncPublic(PublicKey encPublic) {
        this.encPublic = encPublic;
    }

    public GeographicRegionTypeEnum getRegionType() {
        return regionType;
    }

    public void setRegionType(GeographicRegionTypeEnum regionType) {
        this.regionType = regionType;
    }

    public OERCircularRegion getCircularRegion() {
        return circularRegion;
    }

    public void setCircularRegion(OERCircularRegion circularRegion) {
        this.circularRegion = circularRegion;
    }

    public List<OERRectangularRegion> getRectangularRegions() {
        return rectangularRegions;
    }

    public void setRectangularRegions(List<OERRectangularRegion> rectangularRegions) {
        this.rectangularRegions = rectangularRegions;
    }

    public List<OERPolygonalRegion> getPolygonalRegions() {
        return polygonalRegions;
    }

    public void setPolygonalRegions(List<OERPolygonalRegion> polygonalRegions) {
        this.polygonalRegions = polygonalRegions;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public BATCSubjectTypeEnum getBatcType() {
        return batcType;
    }

    public void setBatcType(BATCSubjectTypeEnum batcType) {
        this.batcType = batcType;
    }

    @Override
    public String toString() {
        return "OERTbsCert{" +
                "subjectName='" + subjectName + '\'' +
                ", signPublicKey=" + signPublicKey +
                ", subjectType='" + subjectType + '\'' +
                ", type=" + type +
                ", batcType=" + batcType +
                ", startTime='" + startTime + '\'' +
                ", endTime='" + endTime + '\'' +
                ", startDate=" + startDate +
                ", endDate=" + endDate +
                ", itsAid=" + itsAid +
                ", itsAidSspList=" + itsAidSspList +
                ", encPublic=" + encPublic +
                ", regionType=" + regionType +
                ", circularRegion=" + circularRegion +
                ", rectangularRegions=" + rectangularRegions +
                ", polygonalRegions=" + polygonalRegions +
                ", signEccPointType=" + signEccPointType +
                ", encEccPointType=" + encEccPointType +
                ", signPublicKeyStr='" + signPublicKeyStr + '\'' +
                ", encPublicKeyStr='" + encPublicKeyStr + '\'' +
                '}';
    }
}
