package com.xdja.pki.oer.gbt.asn1.utils.enums;

/**
 * @ClassName BATCSubjectTypeEnum
 * @Description 证书类型枚举
 * @Date 2019/12/18 10:26
 * @Author FengZhen
 */
public enum BATCSubjectTypeEnum {

    /**
     * 注册证书
     */
    ENROLLMENT_CREDENTIAL(0, "EC", "注册证书"),

    /**
     * 假名证书
     */
    PSEUDONYM_CERTIFICATE(1, "PC", "假名证书"),

    /**
     * 假名CA
     */
    PSEUDONYM_AUTHORITY(2, "PCA", "假名CA证书"),

    /**
     * 注册CA证书
     */
    ENROLLMENT_AUTHORITY(3, "ECA", "注册CA证书"),

    /**
     * 根CA证书
     */
    ROOT_CA(4, "RCA", "根CA证书"),

    /**
     * 证书撤销CA证书
     */
    CRL_SIGNER(5, "CRLSIGNER", "证书撤销CA证书"),

    /**
     * 中间CA证书 ICA证书
     */
    INTERMEDIATE_AUTHORITY(8, "ICA", "中间CA证书"),

    /**
     * 策略生成器证书 PG
     */
    POLICE_GENERATOR_AUTHORITY(9, "PG", "策略生成器证书");

    public int id;
    public String value;
    public String desc;

    private BATCSubjectTypeEnum(int id, String value, String desc) {
        this.id = id;
        this.value = value;
        this.desc = desc;
    }

    public static BATCSubjectTypeEnum getSubjectTypeEnum(int id) {
        for (BATCSubjectTypeEnum t : BATCSubjectTypeEnum.values()) {
            if (t.id == id) {
                return t;
            }
        }
        throw new IllegalArgumentException(String.format("BATCSubjectTypeEnum 枚举转换异常[id=%d]", id));
    }

    public static String SubjectTypeEnum(int id) {
        for (BATCSubjectTypeEnum t : BATCSubjectTypeEnum.values()) {
            if (t.id == id) {
                return t.value;
            }
        }
        throw new IllegalArgumentException(String.format("BATCSubjectTypeEnum 枚举转换异常[id=%d]", id));
    }
}
