package com.xdja.pki.oer.gbt.asn1.utils.enums;

public enum CertHashTypeEnum {
    /**
     * SGD_SM3
     */
    SGD_SM3(0, "SGD_SM3"),
    /**
     * SHA_256
     */
    SHA_256(1, "SHA_256");


    public int id;
    public String value;

    private CertHashTypeEnum(int id, String value) {
        this.id = id;
        this.value = value;
    }

    public static CertHashTypeEnum getCertHashType(int id) {
        for (CertHashTypeEnum t : CertHashTypeEnum.values()) {
            if (t.id == id) {
                return t;
            }
        }
        throw new IllegalArgumentException(String.format("CertHashTypeEnum 枚举转换异常[id=%d]", id));
    }

    public static String CertHashType(int id) {
        for (CertHashTypeEnum t : CertHashTypeEnum.values()) {
            if (t.id == id) {
                return t.value;
            }
        }
        throw new IllegalArgumentException(String.format("CertHashTypeEnum 枚举转换异常[id=%d]", id));
    }
}
