package com.xdja.pki.oer.gbt.asn1.utils.enums;

/**
 * @ClassName EccCurveTypeEnum
 * @Description 曲线类型枚举
 * @Date 2019/12/18 10:32
 * @Author FengZhen
 */
public enum  EccCurveTypeEnum {

    /**
     * SGD_SM2
     */
    SGD_SM2(0, "SGD_SM2"),
    /**
     * NIST_P_256
     */
    NIST_P_256(1, "NIST_P_256"),
    /**
     * BRAINPOOL_P_256_R1
     */
    BRAINPOOL_P_256_R1(2, "BRAINPOOL_P_256_R1");


    public int id;
    public String value;

    private EccCurveTypeEnum(int id, String value) {
        this.id = id;
        this.value = value;
    }

    public static EccCurveTypeEnum getCertHashType(int id) {
        for (EccCurveTypeEnum t : EccCurveTypeEnum.values()) {
            if (t.id == id) {
                return t;
            }
        }
        throw new IllegalArgumentException(String.format("EccCurveTypeEnum 枚举转换异常[id=%d]", id));
    }

    public static String CertHashType(int id) {
        for (EccCurveTypeEnum t : EccCurveTypeEnum.values()) {
            if (t.id == id) {
                return t.value;
            }
        }
        throw new IllegalArgumentException(String.format("EccCurveTypeEnum 枚举转换异常[id=%d]", id));
    }
}
