package com.xdja.pki.oer.gbt.asn1.utils.enums;

public enum EccPointTypeEnum {

    /**
     * X_ONLY
     */
    X_ONLY(0, "只传X向量"),
    /**
     * FILL
     */
    FILL(1, "fill"),
    /**
     * COMPRESSED_Y0
     */
    COMPRESSED_Y0(2, "compressedY0"),
    /**
     * COMPRESSED_Y1
     */
    COMPRESSED_Y1(3, "compressedY1"),
    /**
     * 不压缩
     */
    UNCOMPRESSED(4, "uncompressed"),
    /**
     * 压缩
     */
    COMPRESSED_Y(5, "compressed");


    public int id;
    public String value;

    private EccPointTypeEnum(int id, String value) {
        this.id = id;
        this.value = value;
    }

    public static EccPointTypeEnum getEccPointType(int id) {
        for (EccPointTypeEnum t : EccPointTypeEnum.values()) {
            if (t.id == id) {
                return t;
            }
        }
        throw new IllegalArgumentException(String.format("EccPointTypeEnum 枚举转换异常[id=%d]", id));
    }

    public static String EccPointType(int id) {
        for (EccPointTypeEnum t : EccPointTypeEnum.values()) {
            if (t.id == id) {
                return t.value;
            }
        }
        throw new IllegalArgumentException(String.format("EccPointTypeEnum 枚举转换异常[id=%d]", id));
    }
}
