package com.xdja.pki.oer.gbt.asn1.utils.enums;

public enum GeographicRegionTypeEnum {
    /**
     * 圆形
     */
    CIRCULAR_REGION(1, "圆形"),

    /**
     * 矩形
     */
    RECTANGULAR_REGION(2, "矩形"),

    /**
     * 多边形
     */
    POLYGONAL_REGION(3, "多边形"),

    /**
     * 未配置区域
     */
    NO_CONFIGURATION_AREA(4, "未配置区域");

    public int id;
    public String value;

    private GeographicRegionTypeEnum(int id, String value) {
        this.id = id;
        this.value = value;
    }

    public static String getValueFromId(int id) {
        for (GeographicRegionTypeEnum t : GeographicRegionTypeEnum.values()) {
            if (t.id == id) {
                return t.value;
            }
        }
        throw new IllegalArgumentException(String.format("GeographicRegionTypeEnum 枚举转换异常[id=%d]", id));
    }
    public static GeographicRegionTypeEnum getCertHashType(int id) {
        for (GeographicRegionTypeEnum t : GeographicRegionTypeEnum.values()) {
            if (t.id == id) {
                return t;
            }
        }
        throw new IllegalArgumentException(String.format("GeographicRegionTypeEnum 枚举转换异常[id=%d]", id));
    }
}
