package com.xdja.pki.oer.gbt.asn1.utils.enums;

public enum IssueIdTypeEnum {
    /**
     * 空
     */
    NULL(0, "空"),


    /**
     * 证书摘要
     */
    CERTIFICATE_DIGEST(1, "证书摘要");


    public int id;
    public String value;

    private IssueIdTypeEnum(int id, String value) {
        this.id = id;
        this.value = value;
    }

    public static String getValueFromId(int id) {
        for (IssueIdTypeEnum t : IssueIdTypeEnum.values()) {
            if (t.id == id) {
                return t.value;
            }
        }
        throw new IllegalArgumentException(String.format("IssueIdTypeEnum 枚举转换异常[id=%d]", id));
    }

}
