/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.sdk.ca;

import com.xdja.pki.asn1.issue.TBSIssueRequest;
import com.xdja.pki.asn1.issue.TBSIssueResponse;
import com.xdja.pki.issue.PkixIssueCRL;
import com.xdja.pki.issue.PkixIssueCertStatus;
import com.xdja.pki.issue.PkixIssueReq;
import com.xdja.pki.issue.PkixIssueReqBuilder;
import com.xdja.pki.issue.PkixIssueResp;
import com.xdja.pki.issue.TBSIssueCRLReason;
import com.xdja.pki.ldap.config.HttpRequestHeaderConfig;
import com.xdja.pki.ldap.sdk.ca.LDAPResponse;
import java.io.IOException;
import java.security.KeyPair;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Base64;
import java.util.List;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import sun.security.provider.certpath.X509CertificatePair;

public class LDAPCASDK {
    private PkixIssueReqBuilder builder;
    private String ldapUrl;
    private String ocspUrl;
    private X509Certificate ldapSignCert;
    private X509Certificate ocspSignCert;
    private int time;
    private RestTemplate restTemplate = new RestTemplate();
    private String reason;

    public void setTime(int time) {
        this.time = time;
    }

    public LDAPCASDK(X509Certificate caCert, KeyPair cakeyPair, String hashAlgorithm, String ldapUrl, String ocspUrl, X509Certificate ldapSignCert, X509Certificate ocspSignCert) {
        this.ldapSignCert = ldapSignCert;
        this.ocspSignCert = ocspSignCert;
        this.ldapUrl = ldapUrl;
        this.ocspUrl = ocspUrl;
        this.builder = new PkixIssueReqBuilder(cakeyPair, caCert, hashAlgorithm);
    }

    public LDAPResponse updateRootCACertificateToLDAP(X509Certificate oldWithNew, X509Certificate newWithOld, X509Certificate newWithNew) {
        PkixIssueReq req = null;
        try {
            req = this.builder.build(oldWithNew, newWithOld, newWithNew);
        }
        catch (Exception e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "can't build updateRootCACertificateToLDAP PkixisssueReq, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ldapUrl, false);
    }

    public LDAPResponse updateRootCACertificateToOCSP(X509Certificate oldWithNew, X509Certificate newWithOld, X509Certificate newWithNew) {
        PkixIssueReq req = null;
        try {
            req = this.builder.build(oldWithNew, newWithOld, newWithNew);
        }
        catch (Exception e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "can't build updateRootCACertificateToOCSP PkixisssueReq, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ocspUrl, true);
    }

    public LDAPResponse sendCertificate(X509Certificate certificate) {
        PkixIssueReq req = null;
        try {
            req = this.builder.build(certificate);
        }
        catch (Exception e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "can't build sendCertificate PkixisssueReq, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ldapUrl, false);
    }

    public LDAPResponse sendCertificate(List<X509Certificate> certificates) {
        PkixIssueReq req = null;
        try {
            req = this.builder.buildSendCerts(certificates);
        }
        catch (Exception e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "can't build sendCertificateList PkixisssueReq, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ldapUrl, false);
    }

    public LDAPResponse sendCRL(int crlSegment, X509CRL crl) {
        PkixIssueReq req = null;
        try {
            req = this.builder.build(crlSegment, crl);
        }
        catch (Exception e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "can't build sendCRL  PkixisssueReq, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ldapUrl, false);
    }

    public LDAPResponse sendCRL(List<PkixIssueCRL> list) {
        PkixIssueReq req = null;
        try {
            req = this.builder.buildSendCrls(list);
        }
        catch (Exception e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "can't build sendCRLList PkixisssueReq, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ldapUrl, false);
    }

    public LDAPResponse sendCertStatus(TBSIssueCRLReason crlReason, X509Certificate cert) {
        PkixIssueReq req = null;
        try {
            req = this.builder.build(crlReason, cert);
        }
        catch (Exception e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "can't build sendCertStatus PkixisssueReq, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ocspUrl, true);
    }

    public LDAPResponse sendCertStatus(List<PkixIssueCertStatus> list) {
        PkixIssueReq req = null;
        try {
            req = this.builder.buildSendCertStatuses(list);
        }
        catch (Exception e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "can't build sendCertStatusList PkixisssueReq, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ocspUrl, true);
    }

    public LDAPResponse sendCrossCertificate(X509CertificatePair pair) {
        PkixIssueReq req = null;
        try {
            req = this.builder.build(pair);
        }
        catch (Exception e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "can't build sendCrossCertificate PkixisssueReq, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ldapUrl, false);
    }

    public LDAPResponse sendCrossCertificateIssueToThisCA(X509Certificate forward) {
        X509CertificatePair pair = null;
        try {
            pair = new X509CertificatePair(forward, null);
        }
        catch (CertificateException e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "can't use IssueToThisCA  build X509CertificatePair, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        PkixIssueReq req = null;
        try {
            req = this.builder.build(pair);
        }
        catch (Exception e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "can't build sendCrossCertificateToCA PkixisssueReq, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ldapUrl, false);
    }

    public LDAPResponse sendCrossCertificateIssueByThisCA(X509Certificate reverse) {
        X509CertificatePair pair = null;
        try {
            pair = new X509CertificatePair(null, reverse);
        }
        catch (CertificateException e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "can't use IssueByThisCA  build X509CertificatePair, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        PkixIssueReq req = null;
        try {
            req = this.builder.build(pair);
        }
        catch (Exception e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "can't build sendCrossCertificateByCA PkixisssueReq, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ldapUrl, false);
    }

    public LDAPResponse sendCrossCertificate(X509Certificate forward, X509Certificate reverse) {
        X509CertificatePair pair = null;
        try {
            pair = new X509CertificatePair(forward, reverse);
        }
        catch (CertificateException e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "can't use these two certs build X509CertificatePair, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        PkixIssueReq req = null;
        try {
            req = this.builder.build(pair);
        }
        catch (Exception e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "can't build sendCrossCertificate PkixisssueReq, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ldapUrl, false);
    }

    private LDAPResponse run(PkixIssueReq req, String url, boolean isOCSPRes) {
        PkixIssueResp resp;
        ResponseEntity responseEntity;
        HttpHeaders requestHeaders = HttpRequestHeaderConfig.getHeaders();
        HttpEntity requestEntity = null;
        try {
            requestEntity = new HttpEntity((Object)req.getEncoded(), (MultiValueMap)requestHeaders);
        }
        catch (IOException e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "pkixIssueReq getEncode is failure, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        try {
            System.out.println("star send post request, url = " + url);
            System.out.println("Base64 encode PkixIssueReq: " + Base64.getEncoder().encodeToString(req.getEncoded()));
            responseEntity = this.restTemplate.postForEntity(url, (Object)requestEntity, byte[].class, new Object[0]);
            System.out.println("Base64 encode PkixIssueResp: " + Base64.getEncoder().encodeToString((byte[])responseEntity.getBody()));
        }
        catch (Exception e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "Connection refused, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        if (responseEntity.getStatusCode().is4xxClientError()) {
            this.reason = "bad request";
            return new LDAPResponse(false, this.reason);
        }
        if (responseEntity.getStatusCode().is5xxServerError()) {
            this.reason = "Internal Server Error";
            return new LDAPResponse(false, this.reason);
        }
        try {
            resp = new PkixIssueResp((byte[])responseEntity.getBody());
        }
        catch (Exception e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "can't resolve this response struct, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        TBSIssueResponse respIssue = (TBSIssueResponse)resp.getPkixIssue().getTBSIssue();
        TBSIssueRequest reqIssue = (TBSIssueRequest)req.getPkixIssue().getTBSIssue();
        try {
            if (resp.getStatus().getType() == 1) {
                this.reason = "response status code is error, please resend";
                return new LDAPResponse(false, this.reason);
            }
        }
        catch (Exception e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "unknown response status code type , " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        if (!PkixIssueResp.verifyType((TBSIssueRequest)reqIssue, (TBSIssueResponse)respIssue)) {
            this.reason = "request struct's type is not equals response struct's type";
            return new LDAPResponse(false, this.reason);
        }
        if (!PkixIssueResp.verifyNumber((TBSIssueRequest)reqIssue, (TBSIssueResponse)respIssue)) {
            this.reason = "request struct's number is not equals response struct's number";
            return new LDAPResponse(false, this.reason);
        }
        if (!PkixIssueResp.verifyTranNonce((TBSIssueRequest)reqIssue, (TBSIssueResponse)respIssue)) {
            this.reason = "request struct's transNonce is not equals response struct's tranNonce";
            return new LDAPResponse(false, this.reason);
        }
        try {
            if (!PkixIssueResp.verifyTime((TBSIssueResponse)respIssue, (int)this.time)) {
                this.reason = "timeout";
                return new LDAPResponse(false, this.reason);
            }
        }
        catch (ParseException e) {
            System.out.println("error message is : " + e.getMessage());
            this.reason = "can't get response body's time, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        try {
            if (!PkixIssueResp.verifySign((PkixIssueResp)resp, (boolean)isOCSPRes, (X509Certificate)this.ocspSignCert, (X509Certificate)this.ldapSignCert)) {
                this.reason = "signature is not valid";
                return new LDAPResponse(false, this.reason);
            }
        }
        catch (Exception e) {
            this.reason = "can't verify signature, " + e.getMessage();
            return new LDAPResponse(false, this.reason);
        }
        return new LDAPResponse(true, "success");
    }
}

