/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.sdk.ca;

import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class LDAPUrlUtils {
    private LDAPUrlUtils() {
    }

    public static String getCAARLLdapUrl(String host, int port, String issueDn, int crlSegment) throws Exception {
        return LDAPUrlUtils.setCRLExtension(host, port, issueDn, crlSegment, "authorityRevocationList;binary");
    }

    public static String getUserCRLLdapUrl(String host, int port, String issueDn, int crlSegment) throws Exception {
        return LDAPUrlUtils.setCRLExtension(host, port, issueDn, crlSegment, "certificateRevocationList;binary");
    }

    public static String getCertDRLLdapurl(String host, int port, String issueDn, int crlSegment) throws Exception {
        return LDAPUrlUtils.setCRLExtension(host, port, issueDn, crlSegment, "deltaRevocationList;binary");
    }

    public static String getCertIssueLdapurl(String host, int port, String issueDn) {
        return LDAPUrlUtils.setCertExtension(host, port, issueDn, "cACertificate;binary,crossCertificatePair;binary");
    }

    public static String getCASubjectLdapUrl(String host, int port, String subjectDn) {
        return LDAPUrlUtils.setCertExtension(host, port, subjectDn, "cACertificate;binary,crossCertificatePair;binary");
    }

    public static String getUsersubjectLdapUrl(String host, int port, String subjectDn) {
        String url = LDAPUrlUtils.setCertExtension(host, port, subjectDn, "userCertificate;binary");
        return url;
    }

    public static String getCRLIssueLdapUrl(String host, int port, String issueDn) {
        return LDAPUrlUtils.setCertExtension(host, port, issueDn, "cACertificate;binary,crossCertificatePair;binary");
    }

    private static String setCRLExtension(String host, int port, String issueDn, int crlSegment, String name) throws Exception {
        String cn = "crl" + crlSegment;
        LdapName ldapName = new LdapName(issueDn);
        Rdn rdn = ldapName.getRdn(ldapName.size() - 1);
        String rdnString = rdn.toString();
        String dn = "cn=" + cn + ",o=" + rdn.getValue() + "CRL" + issueDn.replace(rdnString, "");
        String url = "ldap://" + host + ":" + port + "/" + dn + "?" + name;
        return url;
    }

    private static String setCertExtension(String host, int port, String dn, String name) {
        String url = "ldap://" + host + ":" + port + "/" + dn + "?" + name;
        return url;
    }
}

