/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.sdk.ca;

import com.sun.jndi.ldap.LdapURL;
import com.xdja.pki.ldap.X509Utils;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPUrlUtils {
    private static Logger logger = LoggerFactory.getLogger(LDAPUrlUtils.class);

    private LDAPUrlUtils() {
    }

    public static String getHostFromLdapUri(String url) {
        LdapURL ldapURL = null;
        try {
            ldapURL = new LdapURL(url);
            return ldapURL.getHost();
        }
        catch (NamingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getIPFromLdapUri(String url) throws NamingException {
        LdapURL ldapURL = null;
        try {
            ldapURL = new LdapURL(url);
            return ldapURL.getPort();
        }
        catch (NamingException e) {
            logger.error("\u4f20\u5165\u7684url\u4e0d\u662f\u4e00\u4e2a\u6b63\u786e\u7684LDAPURL", (Throwable)e);
            throw new NamingException("\u4e0d\u652f\u6301\u4f20\u5165\u7684url");
        }
    }

    public static String genCertArlLdapUri(String host, int port, String issueDn, int crlSegment, String containerName) throws InvalidNameException {
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCRLExtension(host, port, issueDn, crlSegment, "authorityRevocationList;binary", true);
        logger.debug("-------\u521b\u5efaCA\u8bc1\u4e66\u7684ARL\u7684LDAPUri------- " + uri);
        return uri;
    }

    public static String genCertArlLdapUri(String url, String issueDn, int crlSegment, String containerName) throws InvalidNameException {
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCRLExtension(url, issueDn, crlSegment, "authorityRevocationList;binary", true);
        logger.debug("-------\u521b\u5efaCA\u8bc1\u4e66\u7684ARL\u7684LDAPUri------- " + uri);
        return uri;
    }

    public static String genCertArlLdapUri(String host, int port, String issueDn, int stateOrProvinceNum, int crlSegment, String containerName) throws InvalidNameException {
        if (0 == stateOrProvinceNum) {
            return LDAPUrlUtils.genCertArlLdapUri(host, port, issueDn, crlSegment, containerName);
        }
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCRLExtension(host, port, issueDn, stateOrProvinceNum, crlSegment, "authorityRevocationList;binary", true);
        logger.debug("-------\u521b\u5efaCA\u8bc1\u4e66\u7684ARL\u7684LDAPUri------- " + uri);
        return uri;
    }

    public static String genCertArlLdapUri(String url, String issueDn, int stateOrProvinceNum, int crlSegment, String containerName) throws InvalidNameException {
        if (0 == stateOrProvinceNum) {
            return LDAPUrlUtils.genCertArlLdapUri(url, issueDn, crlSegment, containerName);
        }
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCRLExtension(url, issueDn, stateOrProvinceNum, crlSegment, "authorityRevocationList;binary", true);
        logger.debug("-------\u521b\u5efaCA\u8bc1\u4e66\u7684ARL\u7684LDAPUri------- " + uri);
        return uri;
    }

    public static String genCertArlDrlLdapUri(String host, int port, String issueDn, int crlSegment, String containerName) throws InvalidNameException {
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCRLExtension(host, port, issueDn, crlSegment, "deltaRevocationList;binary", true);
        logger.debug("-------\u521b\u5efaCA\u8bc1\u4e66\u7684DRL\u7684LDAPUri-------" + uri);
        return uri;
    }

    public static String genCertArlDrlLdapUri(String url, String issueDn, int crlSegment, String containerName) throws InvalidNameException {
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCRLExtension(url, issueDn, crlSegment, "deltaRevocationList;binary", true);
        logger.debug("-------\u521b\u5efaCA\u8bc1\u4e66\u7684DRL\u7684LDAPUri-------" + uri);
        return uri;
    }

    public static String genCertArlDrlLdapUri(String host, int port, String issueDn, int stateOrProvinceNum, int crlSegment, String containerName) throws InvalidNameException {
        if (0 == stateOrProvinceNum) {
            return LDAPUrlUtils.genCertArlDrlLdapUri(host, port, issueDn, crlSegment, containerName);
        }
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCRLExtension(host, port, issueDn, stateOrProvinceNum, crlSegment, "deltaRevocationList;binary", true);
        logger.debug("-------\u521b\u5efaCA\u8bc1\u4e66\u7684DRL\u7684LDAPUri-------" + uri);
        return uri;
    }

    public static String genCertArlDrlLdapUri(String url, String issueDn, int stateOrProvinceNum, int crlSegment, String containerName) throws InvalidNameException {
        if (0 == stateOrProvinceNum) {
            return LDAPUrlUtils.genCertArlDrlLdapUri(url, issueDn, crlSegment, containerName);
        }
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCRLExtension(url, issueDn, stateOrProvinceNum, crlSegment, "deltaRevocationList;binary", true);
        logger.debug("-------\u521b\u5efaCA\u8bc1\u4e66\u7684DRL\u7684LDAPUri-------" + uri);
        return uri;
    }

    public static String genCertCrlLdapUri(String host, int port, String issueDn, int crlSegment, String containerName) throws InvalidNameException {
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCRLExtension(host, port, issueDn, crlSegment, "certificateRevocationList;binary", false);
        logger.debug("-------\u521b\u5efa\u7528\u6237\u8bc1\u4e66\u7684CRL\u7684LDAPUrl-------" + uri);
        return uri;
    }

    public static String genCertCrlLdapUri(String url, String issueDn, int crlSegment, String containerName) throws InvalidNameException {
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCRLExtension(url, issueDn, crlSegment, "certificateRevocationList;binary", false);
        logger.debug("-------\u521b\u5efa\u7528\u6237\u8bc1\u4e66\u7684CRL\u7684LDAPUrl-------" + uri);
        return uri;
    }

    public static String genCertCrlLdapUri(String host, int port, String issueDn, int stateOrProvinceNum, int crlSegment, String containerName) throws InvalidNameException {
        if (0 == stateOrProvinceNum) {
            return LDAPUrlUtils.genCertCrlLdapUri(host, port, issueDn, crlSegment, containerName);
        }
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCRLExtension(host, port, issueDn, stateOrProvinceNum, crlSegment, "certificateRevocationList;binary", false);
        logger.debug("-------\u521b\u5efa\u7528\u6237\u8bc1\u4e66\u7684CRL\u7684LDAPUrl-------" + uri);
        return uri;
    }

    public static String genCertCrlLdapUri(String url, String issueDn, int stateOrProvinceNum, int crlSegment, String containerName) throws InvalidNameException {
        if (0 == stateOrProvinceNum) {
            return LDAPUrlUtils.genCertCrlLdapUri(url, issueDn, crlSegment, containerName);
        }
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCRLExtension(url, issueDn, stateOrProvinceNum, crlSegment, "certificateRevocationList;binary", false);
        logger.debug("-------\u521b\u5efa\u7528\u6237\u8bc1\u4e66\u7684CRL\u7684LDAPUrl-------" + uri);
        return uri;
    }

    public static String genCertCrlDrlLdapUri(String host, int port, String issueDn, int crlSegment, String containerName) throws InvalidNameException {
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCRLExtension(host, port, issueDn, crlSegment, "deltaRevocationList;binary", false);
        logger.debug("-------\u521b\u5efa\u7528\u6237\u8bc1\u4e66\u7684DRL\u7684LDAPUrl-------" + uri);
        return uri;
    }

    public static String genCertCrlDrlLdapUri(String url, String issueDn, int crlSegment, String containerName) throws InvalidNameException {
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCRLExtension(url, issueDn, crlSegment, "deltaRevocationList;binary", false);
        logger.debug("-------\u521b\u5efa\u7528\u6237\u8bc1\u4e66\u7684DRL\u7684LDAPUrl-------" + uri);
        return uri;
    }

    public static String genCertCrlDrlLdapUri(String host, int port, String issueDn, int stateOrProvinceNum, int crlSegment, String containerName) throws InvalidNameException {
        if (0 == stateOrProvinceNum) {
            return LDAPUrlUtils.genCertCrlDrlLdapUri(host, port, issueDn, crlSegment, containerName);
        }
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCRLExtension(host, port, issueDn, stateOrProvinceNum, crlSegment, "deltaRevocationList;binary", false);
        logger.debug("-------\u521b\u5efa\u7528\u6237\u8bc1\u4e66\u7684DRL\u7684LDAPUrl-------" + uri);
        return uri;
    }

    public static String genCertCrlDrlLdapUri(String url, String issueDn, int stateOrProvinceNum, int crlSegment, String containerName) throws InvalidNameException {
        if (0 == stateOrProvinceNum) {
            return LDAPUrlUtils.genCertCrlDrlLdapUri(url, issueDn, crlSegment, containerName);
        }
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCRLExtension(url, issueDn, stateOrProvinceNum, crlSegment, "deltaRevocationList;binary", false);
        logger.debug("-------\u521b\u5efa\u7528\u6237\u8bc1\u4e66\u7684DRL\u7684LDAPUrl-------" + uri);
        return uri;
    }

    public static String genCertAuthorityLdapUri(String host, int port, String issueDn, String containerName) {
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCertExtension(host, port, issueDn, "cACertificate;binary,crossCertificatePair;binary");
        logger.debug("-------\u521b\u5efa\u8bc1\u4e66\u9881\u53d1\u673a\u6784\u4fe1\u606f\u7684LDAPUrl-------" + uri);
        return uri;
    }

    public static String genCertAuthorityLdapUri(String url, String issueDn, String containerName) {
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCertExtension(url, issueDn, "cACertificate;binary,crossCertificatePair;binary");
        logger.debug("-------\u521b\u5efa\u8bc1\u4e66\u9881\u53d1\u673a\u6784\u4fe1\u606f\u7684LDAPUrl-------" + uri);
        return uri;
    }

    public static String genCACertSubjectLdapUri(String host, int port, String subjectDn, String containerName) {
        subjectDn = LDAPUrlUtils.checkDn(subjectDn, containerName);
        String uri = LDAPUrlUtils.setCertExtension(host, port, subjectDn, "cACertificate;binary,crossCertificatePair;binary");
        logger.debug("-------\u521b\u5efaCA\u8bc1\u4e66\u4e3b\u4f53\u4fe1\u606f\u7684LDAPUrl-------" + uri);
        return uri;
    }

    public static String genCACertSubjectLdapUri(String url, String subjectDn, String containerName) {
        subjectDn = LDAPUrlUtils.checkDn(subjectDn, containerName);
        String uri = LDAPUrlUtils.setCertExtension(url, subjectDn, "cACertificate;binary,crossCertificatePair;binary");
        logger.debug("-------\u521b\u5efaCA\u8bc1\u4e66\u4e3b\u4f53\u4fe1\u606f\u7684LDAPUrl-------" + uri);
        return uri;
    }

    public static String genUserCertSubjectLdapUri(String host, int port, String subjectDn, String containerName) {
        subjectDn = LDAPUrlUtils.checkDn(subjectDn, containerName);
        String uri = LDAPUrlUtils.setCertExtension(host, port, subjectDn, "userCertificate;binary");
        logger.debug("-------\u521b\u5efa\u7528\u6237\u8bc1\u4e66\u4e3b\u4f53\u4fe1\u606f\u7684LDAPUrl-------" + uri);
        return uri;
    }

    public static String genUserCertSubjectLdapUri(String url, String subjectDn, String containerName) {
        subjectDn = LDAPUrlUtils.checkDn(subjectDn, containerName);
        String uri = LDAPUrlUtils.setCertExtension(url, subjectDn, "userCertificate;binary");
        logger.debug("-------\u521b\u5efa\u7528\u6237\u8bc1\u4e66\u4e3b\u4f53\u4fe1\u606f\u7684LDAPUrl-------" + uri);
        return uri;
    }

    public static String genCRLAuthorityLdapUri(String host, int port, String issueDn, String containerName) {
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCertExtension(host, port, issueDn, "cACertificate;binary,crossCertificatePair;binary");
        logger.debug("-------\u521b\u5efaCRL\u7c7b\u578b\u9881\u53d1\u673a\u6784\u4fe1\u606f\u7684LDAPUrl-------" + uri);
        return uri;
    }

    public static String genCRLAuthorityLdapUri(String url, String issueDn, String containerName) {
        issueDn = LDAPUrlUtils.checkDn(issueDn, containerName);
        String uri = LDAPUrlUtils.setCertExtension(url, issueDn, "cACertificate;binary,crossCertificatePair;binary");
        logger.debug("-------\u521b\u5efaCRL\u7c7b\u578b\u9881\u53d1\u673a\u6784\u4fe1\u606f\u7684LDAPUrl-------" + uri);
        return uri;
    }

    private static String setCRLExtension(String host, int port, String issueDn, int crlSegment, String name, boolean isArl) throws InvalidNameException {
        LdapName ldapName = new LdapName(issueDn);
        Rdn rdn = ldapName.getRdn(ldapName.size() - 1);
        String rdnString = rdn.toString();
        if (isArl) {
            String cn = "arl" + crlSegment;
            String dn = "cn=" + cn + ",o=" + X509Utils.transformCommaInDNValues((String)rdn.getValue().toString()) + "ARL" + issueDn.replace(rdnString, "");
            return "ldap://" + host + ":" + port + "/" + dn + "?" + name;
        }
        String cn = "crl" + crlSegment;
        String dn = "cn=" + cn + ",o=" + X509Utils.transformCommaInDNValues((String)rdn.getValue().toString()) + "CRL" + issueDn.replace(rdnString, "");
        return "ldap://" + host + ":" + port + "/" + dn + "?" + name;
    }

    private static String setCRLExtension(String host, int port, String issueDn, int stateOrProvinceNum, int crlSegment, String name, boolean isArl) throws InvalidNameException {
        LdapName ldapName = new LdapName(issueDn);
        Rdn rdn = ldapName.getRdn(ldapName.size() - 1);
        String rdnString = rdn.toString();
        if (isArl) {
            String cn = "arl" + crlSegment;
            String dn = "cn=" + cn + ",st=" + stateOrProvinceNum + ",o=" + X509Utils.transformCommaInDNValues((String)rdn.getValue().toString()) + "ARL" + issueDn.replace(rdnString, "");
            return "ldap://" + host + ":" + port + "/" + dn + "?" + name;
        }
        String cn = "crl" + crlSegment;
        String dn = "cn=" + cn + ",st=" + stateOrProvinceNum + ",o=" + X509Utils.transformCommaInDNValues((String)rdn.getValue().toString()) + "CRL" + issueDn.replace(rdnString, "");
        return "ldap://" + host + ":" + port + "/" + dn + "?" + name;
    }

    private static String setCRLExtension(String url, String issueDn, int crlSegment, String name, boolean isArl) throws InvalidNameException {
        LdapName ldapName = new LdapName(issueDn);
        Rdn rdn = ldapName.getRdn(ldapName.size() - 1);
        String rdnString = rdn.toString();
        if (isArl) {
            String cn = "arl" + crlSegment;
            String dn = "cn=" + cn + ",o=" + X509Utils.transformCommaInDNValues((String)rdn.getValue().toString()) + "ARL" + issueDn.replace(rdnString, "");
            return url + "/" + dn + "?" + name;
        }
        String cn = "crl" + crlSegment;
        String dn = "cn=" + cn + ",o=" + X509Utils.transformCommaInDNValues((String)rdn.getValue().toString()) + "CRL" + issueDn.replace(rdnString, "");
        return url + "/" + dn + "?" + name;
    }

    private static String setCRLExtension(String url, String issueDn, int stateOrProvinceNum, int crlSegment, String name, boolean isArl) throws InvalidNameException {
        LdapName ldapName = new LdapName(issueDn);
        Rdn rdn = ldapName.getRdn(ldapName.size() - 1);
        String rdnString = rdn.toString();
        if (isArl) {
            String cn = "arl" + crlSegment;
            String dn = "cn=" + cn + ",st=" + stateOrProvinceNum + ",o=" + X509Utils.transformCommaInDNValues((String)rdn.getValue().toString()) + "ARL" + issueDn.replace(rdnString, "");
            return url + "/" + dn + "?" + name;
        }
        String cn = "crl" + crlSegment;
        String dn = "cn=" + cn + ",st=" + stateOrProvinceNum + ",o=" + X509Utils.transformCommaInDNValues((String)rdn.getValue().toString()) + "CRL" + issueDn.replace(rdnString, "");
        return url + "/" + dn + "?" + name;
    }

    private static String setCertExtension(String host, int port, String dn, String name) {
        String url = "ldap://" + host + ":" + port + "/" + dn + "?" + name;
        return url;
    }

    private static String setCertExtension(String url, String dn, String name) {
        return url + "/" + dn + "?" + name;
    }

    private static String checkDn(String dn, String containerName) {
        dn = X509Utils.transformCommaInDNValues((String)dn);
        dn = X509Utils.transDN((String)dn);
        return dn;
    }
}

