/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.sdk.ca;

import com.xdja.pki.asn1.issue.TBSIssueRequest;
import com.xdja.pki.asn1.issue.TBSIssueResponse;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.http.GMSSLHttpClient;
import com.xdja.pki.gmssl.http.GMSSLHttpsClient;
import com.xdja.pki.gmssl.http.bean.GMSSLHttpRequest;
import com.xdja.pki.gmssl.http.bean.GMSSLHttpResponse;
import com.xdja.pki.gmssl.http.exception.GMSSLHttpException;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import com.xdja.pki.issue.PkixIssueCRL;
import com.xdja.pki.issue.PkixIssueCertStatus;
import com.xdja.pki.issue.PkixIssueReq;
import com.xdja.pki.issue.PkixIssueReqBuilder;
import com.xdja.pki.issue.PkixIssueResp;
import com.xdja.pki.issue.TBSIssueCRLReason;
import com.xdja.pki.ldap.X509Utils;
import com.xdja.pki.ldap.config.HttpRequestHeaderConfig;
import com.xdja.pki.ldap.sdk.ca.LDAPResponse;
import com.xdja.pki.ldap.sdk.ca.bean.BCRequestBean;
import com.xdja.pki.ldap.sdk.ca.bean.YunHsmRequestBean;
import java.io.IOException;
import java.security.KeyPair;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.provider.certpath.X509CertificatePair;

public class LDAPCASDK {
    private PkixIssueReqBuilder builder;
    private String ldapUrl;
    private String ocspUrl;
    private List<X509Certificate> ldapSignCerts;
    private List<X509Certificate> ocspSignCerts;
    private int time;
    private String reason;
    private X509Certificate userCaCert;
    private boolean isSignByBC;
    private SdfCryptoType sdfCryptoType = SdfCryptoType.YUNHSM;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<X509Certificate> caCerts;

    public void setTime(int time) {
        this.time = time;
    }

    public X509Certificate getUserCaCert() {
        return this.userCaCert;
    }

    public void setUserCaCert(X509Certificate userCaCert) {
        this.userCaCert = userCaCert;
    }

    public LDAPCASDK(List<X509Certificate> caCerts, KeyPair cakeyPair, String ldapUrl, String ocspUrl, List<X509Certificate> ldapSignCerts, List<X509Certificate> ocspSignCerts) {
        this.ldapSignCerts = ldapSignCerts;
        this.ocspSignCerts = ocspSignCerts;
        this.ldapUrl = ldapUrl;
        this.ocspUrl = ocspUrl;
        this.isSignByBC = true;
        this.caCerts = caCerts;
        this.builder = new PkixIssueReqBuilder(cakeyPair, caCerts);
    }

    public LDAPCASDK(List<X509Certificate> caCerts, int privateKeyIndex, String privateKeyPassword, SdfCryptoType sdfCryptoType, String ldapUrl, String ocspUrl, List<X509Certificate> ldapSignCerts, List<X509Certificate> ocspSignCerts) {
        this.ldapSignCerts = ldapSignCerts;
        this.ocspSignCerts = ocspSignCerts;
        this.ldapUrl = ldapUrl;
        this.ocspUrl = ocspUrl;
        this.isSignByBC = privateKeyPassword == null;
        this.caCerts = caCerts;
        this.sdfCryptoType = sdfCryptoType;
        this.builder = new PkixIssueReqBuilder(privateKeyIndex, privateKeyPassword, caCerts, sdfCryptoType);
    }

    public LDAPCASDK(BCRequestBean request) {
        this.ldapSignCerts = request.getLdapSignCerts();
        this.ocspSignCerts = request.getOcspSignCerts();
        this.ldapUrl = request.getLdapUrl();
        this.ocspUrl = request.getOcspUrl();
        this.isSignByBC = true;
        this.caCerts = request.getCaCerts();
        this.builder = new PkixIssueReqBuilder(request.getCakeyPair(), request.getCaCerts());
    }

    public LDAPCASDK(YunHsmRequestBean request) {
        this.ldapSignCerts = request.getLdapSignCerts();
        this.ocspSignCerts = request.getOcspSignCerts();
        this.ldapUrl = request.getLdapUrl();
        this.ocspUrl = request.getOcspUrl();
        this.isSignByBC = null == request.getPrivateKeyPassword();
        this.sdfCryptoType = request.getSdfCryptoType();
        this.caCerts = request.getCaCerts();
        this.builder = new PkixIssueReqBuilder(request.getPrivateKeyIndex(), request.getPrivateKeyPassword(), request.getCaCerts(), this.sdfCryptoType);
    }

    public LDAPResponse updateRootCACertificateToLDAP(X509Certificate oldWithNew, X509Certificate newWithOld, X509Certificate newWithNew) {
        PkixIssueReq req = null;
        try {
            req = this.builder.build(oldWithNew, newWithOld, newWithNew);
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efaPkixIsuse\u7ed3\u6784\u4f53\u5931\u8d25", (Throwable)e);
            this.reason = MessageFormat.format("can not build updateRootCACertificateToLDAP PkixisssueReq, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ldapUrl, false);
    }

    public LDAPResponse updateRootCACertificateToOCSP(X509Certificate oldWithNew, X509Certificate newWithOld, X509Certificate newWithNew) {
        PkixIssueReq req = null;
        try {
            req = this.builder.build(oldWithNew, newWithOld, newWithNew);
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efaPkixIsuse\u7ed3\u6784\u4f53\u5931\u8d25", (Throwable)e);
            this.reason = MessageFormat.format("can not build updateRootCACertificateToOCSP PkixisssueReq, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ocspUrl, true);
    }

    public LDAPResponse sendCertificate(X509Certificate certificate) {
        PkixIssueReq req = null;
        try {
            req = this.builder.build(certificate);
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efaPkixIsuse\u7ed3\u6784\u4f53\u5931\u8d25", (Throwable)e);
            this.reason = MessageFormat.format("can not build sendCertificate PkixisssueReq, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ldapUrl, false);
    }

    public LDAPResponse sendCertificate(List<X509Certificate> certificates) {
        PkixIssueReq req = null;
        try {
            req = this.builder.buildSendCerts(certificates);
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efaPkixIsuse\u7ed3\u6784\u4f53\u5931\u8d25", (Throwable)e);
            this.reason = MessageFormat.format("can not build sendCertificateList PkixisssueReq, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ldapUrl, false);
    }

    public LDAPResponse sendCRL(int crlSegment, X509CRL crl) {
        PkixIssueReq req = null;
        try {
            req = this.builder.build(crlSegment, crl);
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efaPkixIsuse\u7ed3\u6784\u4f53\u5931\u8d25", (Throwable)e);
            this.reason = MessageFormat.format("can not build sendCRL  PkixisssueReq, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ldapUrl, false);
    }

    public LDAPResponse sendCRL(int stateOrProvinceNum, int crlSegment, X509CRL crl) {
        PkixIssueReq req = null;
        try {
            req = this.builder.build(stateOrProvinceNum, crlSegment, crl);
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efaPkixIsuse\u7ed3\u6784\u4f53\u5931\u8d25", (Throwable)e);
            this.reason = MessageFormat.format("can not build sendCRL  PkixisssueReq, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ldapUrl, false);
    }

    public LDAPResponse sendCRL(List<PkixIssueCRL> list) {
        PkixIssueReq req = null;
        try {
            req = this.builder.buildSendCrls(list);
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efaPkixIsuse\u7ed3\u6784\u4f53\u5931\u8d25", (Throwable)e);
            this.reason = MessageFormat.format("can not build sendCRLList PkixisssueReq, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ldapUrl, false);
    }

    public LDAPResponse sendCertStatus(TBSIssueCRLReason crlReason, X509Certificate cert) {
        PkixIssueReq req = null;
        try {
            req = this.builder.build(crlReason, cert, this.userCaCert);
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efaPkixIsuse\u7ed3\u6784\u4f53\u5931\u8d25", (Throwable)e);
            this.reason = MessageFormat.format("can not build sendCertStatus PkixisssueReq, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ocspUrl, true);
    }

    public LDAPResponse sendCertStatus(TBSIssueCRLReason crlReason, X509Certificate cert, Date date) {
        PkixIssueReq req = null;
        try {
            req = this.builder.build(crlReason, cert, date, this.userCaCert);
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efaPkixIsuse\u7ed3\u6784\u4f53\u5931\u8d25", (Throwable)e);
            this.reason = MessageFormat.format("can not build sendCertStatus PkixisssueReq, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ocspUrl, true);
    }

    public LDAPResponse sendCertStatus(List<PkixIssueCertStatus> list) {
        PkixIssueReq req = null;
        try {
            req = this.builder.buildSendCertStatuses(list, this.userCaCert);
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efaPkixIsuse\u7ed3\u6784\u4f53\u5931\u8d25", (Throwable)e);
            this.reason = MessageFormat.format("can not build sendCertStatusList PkixisssueReq, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ocspUrl, true);
    }

    public LDAPResponse sendCrossCertificate(X509CertificatePair pair) {
        PkixIssueReq req = null;
        try {
            req = this.builder.build(pair);
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efaPkixIsuse\u7ed3\u6784\u4f53\u5931\u8d25", (Throwable)e);
            this.reason = MessageFormat.format("can not build sendCrossCertificate PkixisssueReq, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ldapUrl, false);
    }

    public LDAPResponse sendCrossCertificateIssueToThisCA(X509Certificate forward) {
        X509CertificatePair pair = null;
        try {
            pair = new X509CertificatePair(forward, null);
        }
        catch (CertificateException e) {
            this.logger.error("\u4e0d\u80fd\u4f7f\u7528\u8be5\u8bc1\u4e66\u6784\u9020\u4ea4\u53c9\u8bc1\u4e66\u5bf9", (Throwable)e);
            this.reason = MessageFormat.format("can not use IssueToThisCA  build X509CertificatePair, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        PkixIssueReq req = null;
        try {
            req = this.builder.build(pair);
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efaPkixIsuse\u7ed3\u6784\u4f53\u5931\u8d25", (Throwable)e);
            this.reason = MessageFormat.format("can not build sendCrossCertificateToCA PkixisssueReq, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ldapUrl, false);
    }

    public LDAPResponse sendCrossCertificateIssueByThisCA(X509Certificate reverse) {
        X509CertificatePair pair = null;
        try {
            pair = new X509CertificatePair(null, reverse);
        }
        catch (CertificateException e) {
            this.logger.error("\u4e0d\u80fd\u4f7f\u7528\u8be5\u8bc1\u4e66\u6784\u9020\u4ea4\u53c9\u8bc1\u4e66\u5bf9", (Throwable)e);
            this.reason = MessageFormat.format("can not use IssueByThisCA  build X509CertificatePair, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        PkixIssueReq req = null;
        try {
            req = this.builder.build(pair);
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efaPkixIsuse\u7ed3\u6784\u4f53\u5931\u8d25", (Throwable)e);
            this.reason = MessageFormat.format("can not build sendCrossCertificateByCA PkixisssueReq, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ldapUrl, false);
    }

    public LDAPResponse sendCrossCertificate(X509Certificate forward, X509Certificate reverse) {
        X509CertificatePair pair = null;
        try {
            pair = new X509CertificatePair(forward, reverse);
        }
        catch (CertificateException e) {
            this.logger.error("\u4e0d\u80fd\u4f7f\u7528\u8fd9\u4e24\u4e2a\u8bc1\u4e66\u6784\u9020\u4ea4\u53c9\u8bc1\u4e66\u5bf9", (Throwable)e);
            this.reason = MessageFormat.format("can not use these two certs build X509CertificatePair, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        PkixIssueReq req = null;
        try {
            req = this.builder.build(pair);
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efaPkixIsuse\u7ed3\u6784\u4f53\u5931\u8d25", (Throwable)e);
            this.reason = MessageFormat.format("can not build sendCrossCertificate PkixisssueReq, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        return this.run(req, this.ldapUrl, false);
    }

    private LDAPResponse run(PkixIssueReq req, String url, boolean isOCSPRes) {
        PkixIssueResp resp;
        GMSSLHttpClient httpClient;
        GMSSLHttpRequest request = new GMSSLHttpRequest();
        request.setUrl(url);
        request.setHeaders(HttpRequestHeaderConfig.getHeaders());
        if (url.startsWith("https")) {
            try {
                X509Certificate[] certs = new X509Certificate[this.caCerts.size()];
                for (int i = 0; i < this.caCerts.size(); ++i) {
                    certs[i] = this.caCerts.get(i);
                }
                String signAlgName = this.caCerts.get(0).getSigAlgName();
                if (!this.isSignByBC && signAlgName.contains("SM2") && GMSSLCryptoType.XDJA_HSM == GMSSLPkiCryptoInit.getCryptoType()) {
                    httpClient = new GMSSLHttpsClient(certs, this.sdfCryptoType == SdfCryptoType.YUNHSM);
                }
                httpClient = new GMSSLHttpsClient(certs);
            }
            catch (GMSSLHttpException e) {
                this.logger.error("\u6784\u9020 trust keystore \u5f02\u5e38", (Throwable)e);
                this.reason = MessageFormat.format("generate trust keystore is failure, {0}", e.getMessage());
                return new LDAPResponse(false, this.reason);
            }
        } else if (url.startsWith("http")) {
            httpClient = new GMSSLHttpClient();
        } else {
            this.logger.error("\u4f20\u5165\u7684url\u683c\u5f0f\u5f02\u5e38" + url);
            this.reason = MessageFormat.format("url type is error url = {0}", url);
            return new LDAPResponse(false, this.reason);
        }
        GMSSLHttpResponse responseEntity = null;
        try {
            request.setBody(req.getEncoded());
        }
        catch (IOException e) {
            this.logger.error("PkixIsuse\u8f6c\u6362\u4e8c\u8fdb\u5236\u5931\u8d25", (Throwable)e);
            this.reason = MessageFormat.format("pkixIssueReq getEncode is failure, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("start send post request, url = {}", (Object)url);
            }
            responseEntity = httpClient.post(request);
        }
        catch (Exception e) {
            this.logger.error("\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25, ", (Throwable)e);
            this.reason = MessageFormat.format("Connection refused, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        if (responseEntity.getStatusCode() >= 400 && responseEntity.getStatusCode() < 500) {
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
            this.reason = "bad request";
            return new LDAPResponse(false, this.reason);
        }
        if (responseEntity.getStatusCode() >= 500 && responseEntity.getStatusCode() < 600) {
            this.logger.error("\u670d\u52a1\u5668\u521d\u59cb\u5316\u9519\u8bef");
            this.reason = "Internal Server Error";
            return new LDAPResponse(false, this.reason);
        }
        try {
            resp = new PkixIssueResp(responseEntity.getBody());
        }
        catch (Exception e) {
            this.logger.error("\u4e0d\u80fd\u89e3\u6790PkixIssueRessp\u7ed3\u6784\u4f53 ", (Throwable)e);
            this.reason = MessageFormat.format("can not resolve this response struct, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        TBSIssueResponse respIssue = (TBSIssueResponse)resp.getPkixIssue().getTBSIssue();
        TBSIssueRequest reqIssue = (TBSIssueRequest)req.getPkixIssue().getTBSIssue();
        try {
            if (resp.getStatus().getType() == 1) {
                this.logger.error("\u8fd4\u56de\u72b6\u6001\u7801\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u53d1\u9001\u6570\u636e ");
                this.reason = "response status code is error, please resend";
                return new LDAPResponse(false, this.reason);
            }
        }
        catch (Exception e) {
            this.logger.error("\u672a\u77e5\u7684\u8fd4\u56de\u72b6\u6001", (Throwable)e);
            this.reason = MessageFormat.format("unknown response status code type , {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        if (!PkixIssueResp.verifyType((TBSIssueRequest)reqIssue, (TBSIssueResponse)respIssue)) {
            this.logger.error("\u8bf7\u6c42\u7ed3\u6784\u4f53\u548c\u54cd\u5e94\u7ed3\u6784\u4f53\u7684type\u4e0d\u76f8\u540c");
            this.reason = "request struct's type is not equals response struct's type";
            return new LDAPResponse(false, this.reason);
        }
        if (!PkixIssueResp.verifyNumber((TBSIssueRequest)reqIssue, (TBSIssueResponse)respIssue)) {
            this.logger.error("\u8bf7\u6c42\u7ed3\u6784\u4f53\u548c\u54cd\u5e94\u7ed3\u6784\u4f53\u7684number\u4e0d\u76f8\u540c");
            this.reason = "request struct's number is not equals response struct's number";
            return new LDAPResponse(false, this.reason);
        }
        if (!PkixIssueResp.verifyTranNonce((TBSIssueRequest)reqIssue, (TBSIssueResponse)respIssue)) {
            this.logger.error("\u8bf7\u6c42\u7ed3\u6784\u4f53\u548c\u76f8\u5e94\u7ed3\u6784\u4f53\u7684\u968f\u673a\u6570\u4e0d\u76f8\u540c");
            this.reason = "request struct's transNonce is not equals response struct's tranNonce";
            return new LDAPResponse(false, this.reason);
        }
        try {
            if (!PkixIssueResp.verifyTime((TBSIssueResponse)respIssue, (int)this.time)) {
                this.logger.error("\u6536\u5230\u76f8\u5e94\u7684\u65f6\u95f4\u8d85\u8fc7\u4e86\u8bbe\u5b9a\u65f6\u95f4");
                this.reason = "timeout";
                return new LDAPResponse(false, this.reason);
            }
        }
        catch (ParseException e) {
            this.logger.error("\u65e0\u6cd5\u4ece\u54cd\u5e94\u7ed3\u6784\u4f53\u5f97\u5230\u76f8\u5e94\u65f6\u95f4", (Throwable)e);
            this.reason = MessageFormat.format("can not get response body time, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        try {
            if (!PkixIssueResp.verifySign((PkixIssueResp)resp, this.caCerts, (boolean)isOCSPRes, this.ocspSignCerts, this.ldapSignCerts, (boolean)this.isSignByBC, (SdfCryptoType)this.sdfCryptoType)) {
                this.logger.error("\u54cd\u5e94\u7ed3\u6784\u4f53\u7b7e\u540d\u65e0\u6548");
                this.reason = "signature is not valid";
                return new LDAPResponse(false, this.reason);
            }
        }
        catch (Exception e) {
            this.logger.error("\u65e0\u6cd5\u8fdb\u884c\u9a8c\u7b7e", (Throwable)e);
            this.reason = MessageFormat.format("can not verify signature, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        this.logger.info("----------\u64cd\u4f5c\u6210\u529f-----------");
        return new LDAPResponse(true, "success");
    }

    public LDAPResponse run(String sign, String url) {
        GMSSLHttpClient httpClient;
        GMSSLHttpRequest request = new GMSSLHttpRequest();
        request.setUrl(url);
        request.setHeaders(HttpRequestHeaderConfig.getHeaders());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        try {
            String keyStr = X509Utils.getKeyFromCertificate((X509Certificate)this.caCerts.get(0));
            paramMap.put("keyStr", keyStr);
            paramMap.put("sign", sign);
        }
        catch (Exception e) {
            this.logger.error("\u6784\u9020 trust keystore \u5f02\u5e38", (Throwable)e);
            this.reason = MessageFormat.format("generate trust keystore is failure, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        if (url.startsWith("https")) {
            try {
                X509Certificate[] certs = new X509Certificate[this.caCerts.size()];
                for (int i = 0; i < this.caCerts.size(); ++i) {
                    certs[i] = this.caCerts.get(i);
                }
                String signAlgName = this.caCerts.get(0).getSigAlgName();
                if (!this.isSignByBC && signAlgName.contains("SM2") && GMSSLCryptoType.XDJA_HSM == GMSSLPkiCryptoInit.getCryptoType()) {
                    httpClient = new GMSSLHttpsClient(certs, this.sdfCryptoType == SdfCryptoType.YUNHSM);
                }
                httpClient = new GMSSLHttpsClient(certs);
            }
            catch (GMSSLHttpException e) {
                this.logger.error("\u6784\u9020 trust keystore \u5f02\u5e38", (Throwable)e);
                this.reason = MessageFormat.format("generate trust keystore is failure, {0}", e.getMessage());
                return new LDAPResponse(false, this.reason);
            }
        } else if (url.startsWith("http")) {
            httpClient = new GMSSLHttpClient();
        } else {
            this.logger.error("\u4f20\u5165\u7684url\u683c\u5f0f\u5f02\u5e38" + url);
            this.reason = MessageFormat.format("url type is error url = {0}", url);
            return new LDAPResponse(false, this.reason);
        }
        GMSSLHttpResponse responseEntity = null;
        try {
            request.setParams(paramMap);
            responseEntity = httpClient.post(request);
        }
        catch (Exception e) {
            this.logger.error("\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25, ", (Throwable)e);
            this.reason = MessageFormat.format("Connection refused, {0}", e.getMessage());
            return new LDAPResponse(false, this.reason);
        }
        if (responseEntity.getStatusCode() >= 400 && responseEntity.getStatusCode() < 500) {
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
            this.reason = "bad request";
            return new LDAPResponse(false, this.reason);
        }
        if (responseEntity.getStatusCode() >= 500 && responseEntity.getStatusCode() < 600) {
            this.logger.error("\u670d\u52a1\u5668\u521d\u59cb\u5316\u9519\u8bef");
            this.reason = "Internal Server Error";
            return new LDAPResponse(false, this.reason);
        }
        return new LDAPResponse(true, "success");
    }
}

