/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.config;

import com.xdja.pki.ldap.X509Utils;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="ldap.server")
public class LDAPConfiguration {
    private String caCert;
    private String signCert;
    private String signKey;
    private String encCert;
    private String encKey;

    public X509Certificate getCaCert() throws Exception {
        return X509Utils.getX509CertificateFromPEM((String)this.caCert);
    }

    public void setCaCert(String caCert) {
        this.caCert = caCert;
    }

    public X509Certificate getSignCert() throws Exception {
        return X509Utils.getX509CertificateFromPEM((String)this.signCert);
    }

    public void setSignCert(String signCert) {
        this.signCert = signCert;
    }

    public KeyPair getSignKey() throws Exception {
        return X509Utils.getKeyPairFromPEM((String)this.signKey);
    }

    public void setSignKey(String signKey) {
        this.signKey = signKey;
    }

    public X509Certificate getEncCert() throws Exception {
        return X509Utils.getX509CertificateFromPEM((String)this.encCert);
    }

    public void setEncCert(String encCert) {
        this.encCert = encCert;
    }

    public KeyPair getEncKey() throws Exception {
        return X509Utils.getKeyPairFromPEM((String)this.signKey);
    }

    public void setEncKey(String encKey) {
        this.encKey = encKey;
    }
}

