/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.service;

import com.xdja.pki.issue.PkixIssueCRL;
import com.xdja.pki.issue.PkixIssueReq;
import com.xdja.pki.issue.PkixIssueRespBuilder;
import com.xdja.pki.issue.TBSIssueResponseStatus;
import com.xdja.pki.ldap.config.LDAPConfiguration;
import com.xdja.pki.ldap.dao.IDAO;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import sun.security.provider.certpath.X509CertificatePair;

@Service
public class OpenLDAPService {
    @Autowired
    private LDAPConfiguration ldapConfiguration;
    @Autowired
    private IDAO idao;

    public byte[] pkixIssue(PkixIssueReq req, PkixIssueRespBuilder respBuilder) throws Exception {
        switch (req.getTBSIssueType()) {
            case UPDATE_ROOT_CERTIFICATE: {
                List list = req.getCertificateList();
                System.out.println("UPDATE_ROOT_CERTIFICATE " + list.size());
                if (list.size() != 3) {
                    return respBuilder.build(req, TBSIssueResponseStatus.Error).getEncoded();
                }
                X509Certificate certificate = (X509Certificate)list.get(0);
                this.idao.updateRootCACertificate((X509Certificate)req.getCertificateList().get(0), (X509Certificate)req.getCertificateList().get(1), (X509Certificate)req.getCertificateList().get(2));
                break;
            }
            case SEND_CERTIFICATE: {
                List list = req.getCertificateList();
                System.out.println("SEND_CERTIFICATE " + list.size());
                for (X509Certificate cert : list) {
                    this.idao.sendCertificate(cert);
                }
                break;
            }
            case SEND_CRL: {
                List list = req.getCRLList();
                System.out.println("SEND_CRL " + list.size());
                for (PkixIssueCRL pkixIssueCRL : list) {
                    this.idao.sendCRL(pkixIssueCRL.getCrlSegment(), pkixIssueCRL.getCrl());
                }
                break;
            }
            case SEND_CROSS_CERTIFICATE: {
                List list = req.getCertificateList();
                System.out.println("SEND_CROSS_CERTIFICATE " + list.size());
                String caDN = this.ldapConfiguration.getCaCert().getSubjectDN().toString();
                if (list.size() == 1) {
                    X509Certificate cert = (X509Certificate)list.get(0);
                    if (caDN.equals(cert.getSubjectDN().toString())) {
                        try {
                            this.idao.sendCrossCertificate(new X509CertificatePair(cert, null));
                            break;
                        }
                        catch (Exception e) {
                            return respBuilder.build(req, TBSIssueResponseStatus.Error).getEncoded();
                        }
                    }
                    if (caDN.equals(cert.getIssuerDN().toString())) {
                        try {
                            this.idao.sendCrossCertificate(new X509CertificatePair(null, cert));
                            break;
                        }
                        catch (Exception e) {
                            return respBuilder.build(req, TBSIssueResponseStatus.Error).getEncoded();
                        }
                    }
                    return respBuilder.build(req, TBSIssueResponseStatus.Error).getEncoded();
                }
                if (list.size() == 2) {
                    X509CertificatePair pair;
                    try {
                        pair = new X509CertificatePair((X509Certificate)list.get(0), (X509Certificate)list.get(1));
                    }
                    catch (CertificateException e) {
                        return respBuilder.build(req, TBSIssueResponseStatus.Error).getEncoded();
                    }
                    try {
                        this.idao.sendCrossCertificate(pair);
                        break;
                    }
                    catch (Exception e) {
                        return respBuilder.build(req, TBSIssueResponseStatus.Error).getEncoded();
                    }
                }
                return respBuilder.build(req, TBSIssueResponseStatus.Error).getEncoded();
            }
            case SEND_CERTIFICATE_STATUS: {
                List certStatusList = req.getCertStatusList();
                System.out.println(certStatusList);
                break;
            }
            default: {
                throw new Exception("bad request unknown type " + req.getTBSIssueType());
            }
        }
        return respBuilder.build(req, TBSIssueResponseStatus.Normal).getEncoded();
    }
}

