/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.config;

import com.xdja.pki.ldap.X509Utils;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ConfigurationProperties(prefix="ldap.server")
public class LDAPConfiguration {
    private Logger logger = LoggerFactory.getLogger(LDAPConfiguration.class);
    private String caCert;
    private String signCert;
    private String signKey;
    private String encCert;
    private String encKey;
    private int privateKeyIndex;
    private String privateKeyPassword;
    private String cryptoType;

    public String getCryptoType() {
        if (StringUtils.isEmpty((Object)this.cryptoType)) {
            this.cryptoType = "YUNHSM";
        }
        return this.cryptoType;
    }

    public void setCryptoType(String cryptoType) throws Exception {
        this.cryptoType = cryptoType;
        if (!("YUNHSM".equalsIgnoreCase(this.cryptoType) || "PCIE".equalsIgnoreCase(this.cryptoType) || "BC".equalsIgnoreCase(this.cryptoType))) {
            this.logger.error("\u8bf7\u914d\u7f6e\u6b63\u786e\u7684\u7b7e\u540d\u9a8c\u7b7e\u65b9\u5f0f");
            throw new Exception("\u8bf7\u914d\u7f6e\u6b63\u786e\u7684\u7b7e\u540d\u9a8c\u7b7e\u65b9\u5f0f");
        }
        this.logger.info("\u7b7e\u540d\u9a8c\u7b7e\u65b9\u5f0f\u4e3a  " + this.cryptoType);
    }

    public int getPrivateKeyIndex() {
        return this.privateKeyIndex;
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public void setPrivateKeyIndex(int privateKeyIndex) {
        this.privateKeyIndex = privateKeyIndex;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    public List<X509Certificate> getCaCerts() throws Exception {
        return X509Utils.getX509CertificateListFromFile((String)this.caCert);
    }

    public void setCaCert(String caCert) {
        this.caCert = caCert;
    }

    public void updateCaCert(X509Certificate certificate) throws Exception {
        X509Utils.appendCertificateToPem((String)this.caCert, (X509Certificate)certificate);
    }

    public X509Certificate getSignCert() throws Exception {
        return X509Utils.getX509CertificateFromPEM((String)this.signCert);
    }

    public void setSignCert(String signCert) {
        this.signCert = signCert;
    }

    public KeyPair getSignKey() throws Exception {
        return X509Utils.getKeyPairFromPEM((String)this.signKey);
    }

    public void setSignKey(String signKey) {
        this.signKey = signKey;
    }

    public X509Certificate getEncCert() throws Exception {
        return X509Utils.getX509CertificateFromPEM((String)this.encCert);
    }

    public void setEncCert(String encCert) {
        this.encCert = encCert;
    }

    public KeyPair getEncKey() throws Exception {
        return X509Utils.getKeyPairFromPEM((String)this.signKey);
    }

    public void setEncKey(String encKey) {
        this.encKey = encKey;
    }
}

