/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.config;

import com.xdja.pki.gmssl.core.utils.GMSSLECUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECKeyUtils;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;
import com.xdja.pki.ldap.X509Utils;
import java.io.File;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ConfigurationProperties(prefix="ldap.server")
public class LDAPConfiguration {
    private Logger logger = LoggerFactory.getLogger(LDAPConfiguration.class);
    private String caCert;
    private String signCert;
    private String signKey;
    private int privateKeyIndex;
    private String privateKeyPassword;
    private String cryptoType;
    private String privateKey;

    public String getCryptoType() {
        if (StringUtils.isEmpty((Object)this.cryptoType)) {
            this.cryptoType = "YUNHSM";
        }
        return this.cryptoType;
    }

    public void setCryptoType(String cryptoType) throws Exception {
        this.cryptoType = cryptoType;
        if (!("YUNHSM".equalsIgnoreCase(this.cryptoType) || "PCIE".equalsIgnoreCase(this.cryptoType) || "BC".equalsIgnoreCase(this.cryptoType))) {
            this.logger.error("\u8bf7\u914d\u7f6e\u6b63\u786e\u7684\u7b7e\u540d\u9a8c\u7b7e\u65b9\u5f0f");
            throw new Exception("\u8bf7\u914d\u7f6e\u6b63\u786e\u7684\u7b7e\u540d\u9a8c\u7b7e\u65b9\u5f0f");
        }
        this.logger.info("\u7b7e\u540d\u9a8c\u7b7e\u65b9\u5f0f\u4e3a  " + this.cryptoType);
    }

    public int getPrivateKeyIndex() {
        return this.privateKeyIndex;
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public void setPrivateKeyIndex(int privateKeyIndex) {
        this.privateKeyIndex = privateKeyIndex;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    public List<String> getPrivateKey() {
        String[] indexPwd = this.privateKey.split(",");
        return Arrays.asList(indexPwd);
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public List<X509Certificate> getCaCerts() throws Exception {
        String caPem = this.getCaPem();
        if (this.isCaPemExist()) {
            return X509Utils.getX509CertificateListFromFile((String)caPem);
        }
        X509Utils.convertP7BToCaPemJson((String)this.caCert, (String)caPem);
        return X509Utils.convertNestListToList((List)X509Utils.getX509CertificateListFromAllP7B((String)this.caCert));
    }

    public void setCaCert(String caCert) {
        this.caCert = caCert;
    }

    public String getCaPem() {
        String name = "ca.pem";
        return this.caCert + "/" + name;
    }

    private boolean isCaPemExist() {
        String caPem = this.getCaPem();
        File file = new File(caPem);
        return file.exists();
    }

    public void updateCaCert(X509Certificate certificate) throws Exception {
        String caPem = this.getCaPem();
        if (!this.isCaPemExist()) {
            X509Utils.convertP7BToCaPemJson((String)this.caCert, (String)caPem);
        }
        X509Utils.appendCertificateToPem((String)caPem, (X509Certificate)certificate);
    }

    public X509Certificate getSignCert() throws Exception {
        this.initInstance();
        if (this.cryptoType.equalsIgnoreCase("YUNHSM") && this.privateKeyPassword != null) {
            return X509Utils.getX509CertificateFromPEM((String)this.signCert);
        }
        String sign = "sign";
        KeyStore keyStore = X509Utils.readKeyStoreFromPath((String)this.signKey, (char[])"password".toCharArray());
        return (X509Certificate)GMSSLKeyStoreUtils.readCertificateFromKeyStore((KeyStore)keyStore, (String)sign);
    }

    public List<X509Certificate> getAllSignCert(String cryptoType) throws Exception {
        this.initInstance(cryptoType);
        ArrayList<X509Certificate> certificateList = new ArrayList();
        certificateList = X509Utils.getX509CertificateFromAllPEM((String)this.signCert);
        String sign = "sign";
        List keyStores = X509Utils.readAllKeyStoreFromPath((String)this.signKey, (char[])"password".toCharArray());
        if (keyStores != null && keyStores.size() > 0) {
            for (int i = 0; i < keyStores.size(); ++i) {
                certificateList.add((X509Certificate)GMSSLKeyStoreUtils.readCertificateFromKeyStore((KeyStore)((KeyStore)keyStores.get(i)), (String)sign));
            }
        }
        return certificateList;
    }

    public void setSignCert(String signCert) {
        this.signCert = signCert;
    }

    public KeyPair getSignKey() throws Exception {
        String sign = "sign";
        KeyStore keyStore = X509Utils.readKeyStoreFromPath((String)this.signKey, (char[])"password".toCharArray());
        PrivateKey privateKey = GMSSLKeyStoreUtils.readPrivateKeyFromKeyStore((KeyStore)keyStore, (char[])"password".toCharArray(), (String)sign);
        Certificate certificate = GMSSLKeyStoreUtils.readCertificateFromKeyStore((KeyStore)keyStore, (String)sign);
        return new KeyPair(certificate.getPublicKey(), privateKey);
    }

    public List<KeyPair> getAllSignKey() throws Exception {
        ArrayList<KeyPair> keyPairList = new ArrayList<KeyPair>();
        String sign = "sign";
        List keyStores = X509Utils.readAllKeyStoreFromPath((String)this.signKey, (char[])"password".toCharArray());
        if (keyStores != null && keyStores.size() > 0) {
            for (int i = 0; i < keyStores.size(); ++i) {
                PrivateKey privateKey = GMSSLKeyStoreUtils.readPrivateKeyFromKeyStore((KeyStore)((KeyStore)keyStores.get(i)), (char[])"password".toCharArray(), (String)sign);
                Certificate certificate = GMSSLKeyStoreUtils.readCertificateFromKeyStore((KeyStore)((KeyStore)keyStores.get(i)), (String)sign);
                KeyPair keyPair = new KeyPair(certificate.getPublicKey(), privateKey);
                keyPairList.add(keyPair);
            }
        }
        return keyPairList;
    }

    public void setSignKey(String signKey) {
        this.signKey = signKey;
    }

    public void initInstance() {
        if ("YUNHSM".equalsIgnoreCase(this.cryptoType)) {
            if (this.privateKeyPassword == null) {
                try {
                    GMSSLPkiCryptoInit.getSancHsmInstance();
                }
                catch (Exception e) {
                    this.logger.error("\u83b7\u53d6Sanc hsm instance\u5f02\u5e38");
                }
            } else {
                GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            }
        }
        if ("PCIE".equalsIgnoreCase(this.cryptoType)) {
            GMSSLPkiCryptoInit.getPcieInstance();
        }
        if ("BC".equalsIgnoreCase(this.cryptoType)) {
            GMSSLPkiCryptoInit.getBCInstance();
        }
    }

    public void initInstance(String cryptoType) {
        if ("YUNHSM".equalsIgnoreCase(cryptoType)) {
            if (this.privateKeyPassword == null) {
                try {
                    GMSSLPkiCryptoInit.getSancHsmInstance();
                }
                catch (Exception e) {
                    this.logger.error("\u83b7\u53d6Sanc hsm instance\u5f02\u5e38");
                }
            } else {
                GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            }
        }
        if ("PCIE".equalsIgnoreCase(cryptoType)) {
            GMSSLPkiCryptoInit.getPcieInstance();
        }
        if ("BC".equalsIgnoreCase(cryptoType)) {
            GMSSLPkiCryptoInit.getBCInstance();
        }
    }

    public Map<String, Object> getCAToLDAPMap(String cryptoType) throws Exception {
        HashMap<String, Object> caLdapMap = new HashMap<String, Object>();
        List caCertsList = X509Utils.getX509CertificateListFromAllP7B((String)this.caCert);
        List<X509Certificate> signCertList = this.getAllSignCert(cryptoType);
        List<KeyPair> keyPairs = this.getAllSignKey();
        List<String> privateKeys = this.getPrivateKey();
        for (int i = 0; i < caCertsList.size(); ++i) {
            ArrayList<Object> tempCALDAPList = new ArrayList<Object>();
            List x509Certificates = (List)caCertsList.get(i);
            X509Certificate x509Cert = (X509Certificate)x509Certificates.get(x509Certificates.size() - 1);
            String keyStr = X509Utils.getKeyFromCertificate((X509Certificate)x509Cert);
            String signAlg = x509Cert.getSigAlgName();
            tempCALDAPList.add(x509Certificates);
            for (int j = 0; j < signCertList.size(); ++j) {
                X509Certificate serverCert = signCertList.get(j);
                if (!X509Utils.verifyCert((List)x509Certificates, (X509Certificate)serverCert)) continue;
                tempCALDAPList.add(signCertList.get(j));
                for (int k = 0; k < keyPairs.size(); ++k) {
                    KeyPair keyPair = keyPairs.get(k);
                    if (serverCert.getSigAlgName().contains("SM2") || !serverCert.getPublicKey().equals(keyPair.getPublic())) continue;
                    tempCALDAPList.add(keyPair);
                }
                if (!"YUNHSM".equalsIgnoreCase(cryptoType) || !signAlg.contains("SM2") || !serverCert.getSigAlgName().contains("SM2")) continue;
                BCECPublicKey bcecPublicKeyFromCert = (BCECPublicKey)serverCert.getPublicKey();
                for (int l = 0; l < privateKeys.size(); ++l) {
                    BCECPublicKey bcecPublicKeyFromHsm;
                    String[] privateKey = privateKeys.get(l).split("-");
                    if (privateKey.length != 2 || !bcecPublicKeyFromCert.equals((Object)(bcecPublicKeyFromHsm = (BCECPublicKey)GMSSLECKeyUtils.getSignPublicKeyByYunhsm((int)Integer.parseInt(privateKey[0]), (String)GMSSLECUtils.SM2p256)))) continue;
                    tempCALDAPList.add(privateKey);
                }
            }
            caLdapMap.put(keyStr, tempCALDAPList);
        }
        return caLdapMap;
    }
}

