package com.xdja.pki.auditlog.dao;

import com.alibaba.druid.util.StringUtils;
import com.xdja.pki.core.bean.PageInfo;
import com.xdja.pki.auditlog.dao.model.ArchiveLogDO;
import com.xdja.pki.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import org.nutz.dao.Cnd;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ArchiveLogDao class
 * @Description: 归档日志dao层
 * @Author: songxuetao
 * @Modifiedby:
 **/
@Repository
public class ArchiveLogDao extends BaseJdbcDao {

    /**
     * @MethodName: listArchiveLog
     * @Description: 查询归档日志
     * @Param: pageNo
     * @Param: pageSize
     * @Param: operatorType
     * @Param: startTime
     * @Param: endTime
     * @Param: isExport 是否导出，根据该标志返回不同对象
     * @Return: java.lang.Object
     * @Author: songxuetao
    **/
    public Object listArchiveLog(Integer pageNo, Integer pageSize, Integer operatorType, String startTime, String endTime, boolean isExport) {
        Cnd cnd = Cnd.NEW();

        if (null != operatorType) {
            cnd.and("operator_type", "=", operatorType);
        }

        if (!StringUtils.isEmpty(startTime) && !StringUtils.isEmpty(endTime)) {
            cnd.and("gmt_create", ">", startTime + " 00:00:00");
            cnd.and("gmt_create", "<", endTime + " 23:59:59");
        }
        //归档日志按归档时间降序排列
        cnd.orderBy("archive_create", "desc");

        try {
            if (isExport) {
                return this.daoTemplate.query(ArchiveLogDO.class, cnd);
            }
            PageInfo pageInfo = new PageInfo(pageNo, pageSize, this.daoTemplate.count(ArchiveLogDO.class, cnd));
            pageInfo.setDatas(this.daoTemplate.query(ArchiveLogDO.class, cnd, createPager(pageNo, pageSize)));
            logger.debug("list page info {} ", pageInfo);
            return pageInfo;
        } catch (Exception e) {
            throw new DAOException("查询归档日志列表时数据库异常", e);
        }
    }

    public ArchiveLogDO get(int id){
        Cnd cnd = Cnd.where("id", "=", id);
        try {
            List<ArchiveLogDO> archiveLogDOS = this.daoTemplate.query(ArchiveLogDO.class, cnd);
            if (archiveLogDOS.size() != 1) {
                throw new DAOException("根据ID获取到:" + archiveLogDOS.size() + "个数据!");
            }
            return archiveLogDOS.get(0);
        } catch (Exception e) {
            throw new DAOException("根据id查询审计日志数据库异常", e);
        }
    }

    public int saveArchiveLogList(List<ArchiveLogDO> archiveLogDOList){
        return this.daoTemplate.insert(archiveLogDOList).size();
    }

}
