package com.xdja.pki.auditlog.dao;

import com.alibaba.druid.util.StringUtils;
import com.xdja.pki.auditlog.dao.model.AuditorOperateLogDO;
import com.xdja.pki.core.bean.PageInfo;
import com.xdja.pki.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import org.nutz.dao.Cnd;
import org.nutz.dao.DaoException;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: AuditorOperateLogDao class
 * @Description: 审计员操作日志DAO
 * @Author: songxuetao
 * @Modifiedby:
 **/
@Repository
public class AuditorOperateLogDao extends BaseJdbcDao {

    public AuditorOperateLogDO save(AuditorOperateLogDO auditorOperateLogDO){
        return this.daoTemplate.insert(auditorOperateLogDO);
    }

    public AuditorOperateLogDO get(int id){
        Cnd cnd = Cnd.where("id", "=", id);
        try{
            List<AuditorOperateLogDO> auditorOperateLogDOS = this.daoTemplate.query(AuditorOperateLogDO.class, cnd);
            if (auditorOperateLogDOS.size() != 1){
                throw new DaoException("根据ID获取到:" + auditorOperateLogDOS.size() + "个数据!");
            }
            return auditorOperateLogDOS.get(0);
        } catch (Exception e){
            throw new DAOException("根据id查询审计员操作日志数据库异常", e);
        }
    }

    public Object listAuditorOperateLog(Integer pageNo, Integer pageSize, String auditSubject, Integer auditType, String startTime, String endTime, boolean isExport) {
        Cnd cnd = Cnd.NEW();

        if (!StringUtils.isEmpty(auditSubject)) {
            cnd.and("audit_subject", "LIKE", "%" + auditSubject + "%");
        }

        if (null != auditType) {
            cnd.and("audit_type", "=", auditType);
        }

        if (!StringUtils.isEmpty(startTime) && !StringUtils.isEmpty(endTime)) {
            cnd.and("gmt_create", ">", startTime + " 00:00:00");
            cnd.and("gmt_create", "<", endTime + " 23:59:59");
        }
        cnd.orderBy("gmt_create", "desc");

        try {
            if (isExport) {
                return this.daoTemplate.query(AuditorOperateLogDO.class, cnd);
            }
            PageInfo pageInfo = new PageInfo(pageNo, pageSize, this.daoTemplate.count(AuditorOperateLogDO.class, cnd));
            pageInfo.setDatas(this.daoTemplate.query(AuditorOperateLogDO.class, cnd, createPager(pageNo, pageSize)));
            logger.debug("list page info {} ", pageInfo);
            return pageInfo;
        } catch (Exception e) {
            throw new DAOException("查询审计员操作日志列表时数据库异常", e);
        }
    }
}
