package com.xdja.pki.auditlog.dao;

import com.xdja.pki.auditlog.dao.model.AuditLogDO;
import com.xdja.pki.auditlog.dao.model.PeriodAuditLogDO;
import com.xdja.pki.auditlog.dao.model.PeriodAuditLogRelationDO;
import com.xdja.pki.core.bean.PageInfo;
import com.xdja.pki.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

/**
 * 操作日志表 - 数据访问层
 *
 * @author syg
 */
@Repository
public class PeriodAuditLogDao extends BaseJdbcDao {

    public List<AuditLogDO> getAuditLogByPeriodId(List<Long> auditLogIds) {
        try{
            List<AuditLogDO> list = new ArrayList<>();
            for(Long id : auditLogIds) {
                AuditLogDO auditLogDO = this.daoTemplate.fetch(AuditLogDO.class, id);
                list.add(auditLogDO);
            }
            if (null == list) {
                throw new DAOException("根据周期审计日志ID获取到审计日志为空!");
            }
            return list;
        } catch (Exception e) {
            throw new DAOException("根据id查询周期审计日志数据库异常", e);
        }
    }

    public PeriodAuditLogDO savePeriodAuditLog(PeriodAuditLogDO logDO) {
        return this.daoTemplate.insert(logDO);
    }

    /**
     * 读取 周期审计日志列表 分页数据
     *
     * @param pageNo          页码
     * @param pageSize        每页个数
     * @param startTime       开始时间 过滤项
     * @param endTime         结束时间 过滤项
     * @return 日志列表信息
     */
    public Object getPeriodAuditLogList(Integer pageNo, Integer pageSize, String startTime, String endTime) {
        Cnd cnd = Cnd.NEW();
        if (StringUtils.isNotBlank(startTime) && StringUtils.isNotBlank(endTime)) {
            cnd.and("gmt_create", ">=", startTime);
            cnd.and("gmt_create", "<=", endTime);
        }
        //id 降序
        cnd.orderBy("id", "desc");

        try {
            if (pageNo == 0 && pageSize == 0) {
                return this.daoTemplate.query(PeriodAuditLogDO.class, cnd);
            }
            PageInfo pageInfo = new PageInfo(pageNo, pageSize, this.daoTemplate.count(PeriodAuditLogDO.class, cnd));
            pageInfo.setDatas(this.daoTemplate.query(PeriodAuditLogDO.class, cnd, createPager(pageNo, pageSize)));
            logger.debug("list page info {} ", pageInfo);
            return pageInfo;
        } catch (Exception e) {
            throw new DAOException("分页查询周期审计日志列表时数据库异常", e);
        }
    }

    public PeriodAuditLogDO getPeriodAuditLogById(long periodLogId) {
        Cnd cnd = Cnd.where("id", "=", periodLogId);
        cnd.orderBy("gmt_create", "desc");
        try {
            List<PeriodAuditLogDO> list = this.daoTemplate.query(PeriodAuditLogDO.class, cnd);
            if (list.size() > 1) {
                throw new DAOException("根据ID获取到:" + list.size() + "个数据!");
            }
            if (list.isEmpty()) {
                return null;
            }
            return list.get(0);
        } catch (Exception e) {
            throw new DAOException("根据id获取周期审计日志数据库异常", e);
        }
    }

    public PeriodAuditLogDO getMaxIdPeriodAuditLog(){
        try {
            String sql = "select * from period_audit_log where id = (select max(id) from period_audit_log)";
            List<PeriodAuditLogDO> list = new ArrayList<>();
            list = this.daoTemplate.queryForList(sql, null, BeanPropertyRowMapper.newInstance(PeriodAuditLogDO.class));
            if(list.isEmpty()){
                return null;
            }
            return list.get(0);
        } catch (Exception e) {
            throw new DAOException("根据id获取周期审计日志数据库异常", e);
        }
    }
}