package com.xdja.pki.auditlog.dao;

import com.xdja.pki.auditlog.dao.model.AuditLogDO;
import com.xdja.pki.auditlog.dao.model.PeriodAuditLogDO;
import com.xdja.pki.auditlog.dao.model.PeriodAuditLogRelationDO;
import com.xdja.pki.core.bean.PageInfo;
import com.xdja.pki.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

/**
 * 操作日志表 - 数据访问层
 *
 * @author syg
 */
@Repository
public class PeriodAuditLogRelationDao extends BaseJdbcDao {

    public List<Long> getAuditLogIdByPeriodId(long periodLogId) {
        try{
            List<Long> auditLogIds = new ArrayList<>();
            String sql = "select audit_log_id from period_audit_log_relation WHERE period_log_id = :periodLogId order by audit_log_id desc";

            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("periodLogId", periodLogId);
            auditLogIds = this.daoTemplate.queryColumnLongForList(sql, params, "audit_log_id");
            
            return auditLogIds;
        } catch (Exception e) {
            throw new DAOException("根据id查询审计日志ID数据库异常", e);
        }
    }

    public PageInfo getPageInfoByPeriodId(long periodLogId, Integer pageNo, Integer pageSize){
        Cnd cnd = Cnd.where("period_log_id", "=", periodLogId);

        //周期内审计日志id 降序
        cnd.orderBy("audit_log_id", "desc");

        try {
            PageInfo pageInfo = new PageInfo(pageNo, pageSize, this.daoTemplate.count(PeriodAuditLogRelationDO.class, cnd));
            pageInfo.setDatas(this.daoTemplate.query(PeriodAuditLogRelationDO.class, cnd, createPager(pageNo, pageSize)));
            logger.debug("list page info {} ", pageInfo);
            return pageInfo;
        } catch (Exception e) {
            throw new DAOException("分页根据id查询审计日志ID数据库异常", e);
        }
    }

    public int insertList(List<PeriodAuditLogRelationDO> list){
       return this.daoTemplate.insert(list).size();
    }

    public int deletePeriodAuditLogRelationByAuditLogId(List<Long> auditLogIds){
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("DELETE FROM period_audit_log_relation WHERE audit_log_id IN (:auditLogIds) ");
            MapSqlParameterSource paramSource = new MapSqlParameterSource();
            paramSource.addValue("auditLogIds", auditLogIds);
            return this.daoTemplate.deleteBySql(sb.toString(), paramSource);
        } catch (Exception e){
            logger.error("根据AuditLogId删除周期审计日志关系表数据异常", e);
            throw new DAOException("根据AuditLogId删除周期审计日志关系表数据异常", e);
        }
    }
}