package com.xdja.pki.auditlog.dao.model;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import org.nutz.dao.entity.annotation.ColDefine;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.entity.annotation.Column;
import org.nutz.dao.entity.annotation.Comment;
import org.nutz.dao.entity.annotation.Id;
import org.nutz.dao.entity.annotation.Table;

import java.io.Serializable;
import java.util.Date;

/**
 * 操作日志表实体
 */
@Table("audit_log")
@Comment("审计日志")
public class AuditLogDO implements Serializable {
    private static final Long serialVersionUID = 1L;

    @Id
    @Column("id")
    @Comment("主键、自增")
    private Long id;

    @Column("operator_subject")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("操作员证书主体")
    private String operatorSubject;

    @Column("operator_sn")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("操作员证书序列号")
    private String operatorSn;

    @Column("operator_cert_id")
    @ColDefine(type = ColType.INT)
    @Comment("操作员证书ID")
    private Long operatorCertId;

    @Column("operator_type")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("操作类型，对应字典表code`audit_log_operator_type`字段")
    private String operatorType;

    @Column("operate_client_ip")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("操作客户端IP")
    private String operateClientIp;

    @Column("operate_content")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("操作内容")
    private String operateContent;

    @Column("operate_result")
    @ColDefine(type = ColType.INT)
    @Comment("操作结果，1-成功；2-失败")
    private Integer operateResult;

    @Column("operate_modify_detail")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("操作内容")
    private String operateModifyDetail;

    @Column("operate_sign")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("操作员签名")
    private String operateSign;

    @Column("is_audit")
    @ColDefine(type = ColType.INT)
    @Comment("是否审核，1-未审核；2-已审核")
    private Integer isAudit;

    @Column("is_verify")
    @ColDefine(type = ColType.INT)
    @Comment("验签结果，1-签名不一致；2-签名一致")
    private Integer isVerify;

    @Column("audit_subject")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("审计员证书主体")
    private String auditSubject;

    @Column("audit_sn")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("审计员证书序列号")
    private String auditSn;

    @Column("audit_cert_id")
    @ColDefine(type = ColType.INT)
    @Comment("审计员证书ID")
    private Long auditCertId;

    @Column("audit_note")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("审计员审核备注")
    private String auditNote;

    @Column("audit_sign")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("审计员签名")
    private String auditSign;

    @Column("server_sign")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("服务器签名")
    private String serverSign;

    @Column("server_cert_id")
    @ColDefine(type = ColType.INT)
    @Comment("服务器证书ID")
    private Long serverCertId;

    @Column("gmt_create")
    @ColDefine(type = ColType.DATETIME)
    @Comment("操作时间")
    private Date operateTime;

    @Column("gmt_modified")
    @ColDefine(type = ColType.DATETIME)
    @Comment("审计时间")
    private Date auditTime;

    @Column("audit_client_ip")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("审计客户端IP")
    private String auditClientIp;

    public String getAuditClientIp() {
        return auditClientIp;
    }

    public void setAuditClientIp(String auditClientIp) {
        this.auditClientIp = auditClientIp;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOperatorSubject() {
        return operatorSubject;
    }

    public void setOperatorSubject(String operatorSubject) {
        this.operatorSubject = operatorSubject;
    }

    public String getOperatorSn() {
        return operatorSn;
    }

    public void setOperatorSn(String operatorSn) {
        this.operatorSn = operatorSn;
    }

    public Long getOperatorCertId() {
        return operatorCertId;
    }

    public void setOperatorCertId(Long operatorCertId) {
        this.operatorCertId = operatorCertId;
    }

    public String getOperatorType() {
        return operatorType;
    }

    public void setOperatorType(String operatorType) {
        this.operatorType = operatorType;
    }

    public String getOperateClientIp() {
        return operateClientIp;
    }

    public void setOperateClientIp(String operateClientIp) {
        this.operateClientIp = operateClientIp;
    }

    public String getOperateContent() {
        return operateContent;
    }

    public void setOperateContent(String operateContent) {
        this.operateContent = operateContent;
    }

    public Integer getOperateResult() {
        return operateResult;
    }

    public void setOperateResult(Integer operateResult) {
        this.operateResult = operateResult;
    }

    public String getOperateModifyDetail() {
        return operateModifyDetail;
    }

    public void setOperateModifyDetail(String operateModifyDetail) {
        this.operateModifyDetail = operateModifyDetail;
    }

    public String getOperateSign() {
        return operateSign;
    }

    public void setOperateSign(String operateSign) {
        this.operateSign = operateSign;
    }

    public Integer getIsAudit() {
        return isAudit;
    }

    public void setIsAudit(Integer isAudit) {
        this.isAudit = isAudit;
    }

    public String getAuditSubject() {
        return auditSubject;
    }

    public void setAuditSubject(String auditSubject) {
        this.auditSubject = auditSubject;
    }

    public String getAuditSn() {
        return auditSn;
    }

    public void setAuditSn(String auditSn) {
        this.auditSn = auditSn;
    }

    public Long getAuditCertId() {
        return auditCertId;
    }

    public void setAuditCertId(Long auditCertId) {
        this.auditCertId = auditCertId;
    }

    public String getAuditNote() {
        return auditNote;
    }

    public void setAuditNote(String auditNote) {
        this.auditNote = auditNote;
    }

    public String getAuditSign() {
        return auditSign;
    }

    public void setAuditSign(String auditSign) {
        this.auditSign = auditSign;
    }

    public String getServerSign() {
        return serverSign;
    }

    public void setServerSign(String serverSign) {
        this.serverSign = serverSign;
    }

    public Long getServerCertId() {
        return serverCertId;
    }

    public void setServerCertId(Long serverCertId) {
        this.serverCertId = serverCertId;
    }

    public Date getOperateTime() {
        return operateTime;
    }

    public void setOperateTime(Date operateTime) {
        this.operateTime = operateTime;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public Integer getIsVerify() {
        return isVerify;
    }

    public void setIsVerify(Integer isVerify) {
        this.isVerify = isVerify;
    }

    public String operatorBase64Encode() {
        String s = "AuditLogDO{" +
                " operatorSubject='" + operatorSubject + "\'" +
                ", operatorSn='" + operatorSn + "\'" +
                ", operatorCertId=" + operatorCertId +
                ", operatorType='" + operatorType + "\'" +
                ", operateClientIp='" + operateClientIp + "\'" +
                ", operateContent='" + operateContent + "\'" +
                ", operateResult=" + operateResult +
                ", operateSign='" + operateSign + "\'" +
                ", operateTime=" + operateTime +
                "}";
        return GMSSLByteArrayUtils.base64Encode(s.getBytes());
    }

    public String operatorWithAuditInfoBase64Encode() {
        String s = "AuditLogDO{" +
                " operatorSubject='" + operatorSubject + "\'" +
                ", operatorSn='" + operatorSn + "\'" +
                ", operatorCertId=" + operatorCertId +
                ", operatorType='" + operatorType + "\'" +
                ", operateClientIp='" + operateClientIp + "\'" +
                ", operateContent='" + operateContent + "\'" +
                ", operateResult=" + operateResult +
                ", operateSign='" + operateSign + "\'" +
                ", operateTime=" + operateTime +
                ", auditSubject='" + auditSubject + "\'" +
                ", auditSn='" + auditSn + "\'" +
                ", auditCertId=" + auditCertId +
                ", auditClientIp='" + auditClientIp + "\'" +
                ", auditNote='" + auditNote + "\'" +
                ", auditSign='" + auditSign +
                "}";
        return GMSSLByteArrayUtils.base64Encode(s.getBytes());
    }
}
