package com.xdja.pki.auditlog.dao.model;

import org.nutz.dao.entity.annotation.*;

import java.io.Serializable;
import java.util.Date;


/**
 * DO（ Data Object）：与数据库表结构一一对应，通过DAO层向上传输数据源对象
 * 审计日志 表结构对应 数据源对象
 */
@Table("audit_log")
@Comment("审计日志")
public class AuditLogListDO implements Serializable {
	private static final long serialVersionUID = 1L;
	
	@Id
	@Column("id")
	@Comment("主键、自增")
	private Long id;
	
	@Column("operator_subject")
	@ColDefine(type = ColType.VARCHAR)
	@Comment("操作员证书主体")
	private String operatorSubject;

	@Column("operator_type")
	@ColDefine(type = ColType.VARCHAR)
	@Comment("操作类型，对应字典表code`audit_log_operator_type`字段")
	private String operatorType;
	
	@Column("operate_client_ip")
	@ColDefine(type = ColType.VARCHAR)
	@Comment("操作客户端IP")
	private String operateClientIp;

    @Column("operate_result")
    @ColDefine(type = ColType.INT)
    @Comment("操作结果，1-成功；2-失败")
    private Integer operateResult;

    @Column("is_audit")
	@ColDefine(type = ColType.INT)
	@Comment("是否审核，1-未审核；2-已审核")
	private Integer isAudit;

	@Column("gmt_create")
	@ColDefine(type = ColType.DATETIME)
	@Comment("创建时间")
	private Date operateTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOperatorSubject() {
        return operatorSubject;
    }

    public void setOperatorSubject(String operatorSubject) {
        this.operatorSubject = operatorSubject;
    }

    public String getOperatorType() {
        return operatorType;
    }

    public void setOperatorType(String operatorType) {
        this.operatorType = operatorType;
    }

    public String getOperateClientIp() {
        return operateClientIp;
    }

    public void setOperateClientIp(String operateClientIp) {
        this.operateClientIp = operateClientIp;
    }

    public Integer getOperateResult() {
        return operateResult;
    }

    public void setOperateResult(Integer operateResult) {
        this.operateResult = operateResult;
    }

    public Integer getIsAudit() {
        return isAudit;
    }

    public void setIsAudit(Integer isAudit) {
        this.isAudit = isAudit;
    }

    public Date getOperateTime() {
        return this.operateTime;
    }

    public void setOperateTime(Date operateTime) {
        this.operateTime = operateTime;
    }

    @Override
    public String toString() {
        return "AuditLogListDO{" +
                "id=" + id +
                ", operatorSubject='" + operatorSubject + '\'' +
                ", operatorType='" + operatorType + '\'' +
                ", operateClientIp='" + operateClientIp + '\'' +
                ", operateResult=" + operateResult +
                ", isAudit=" + isAudit +
                ", operateTime=" + operateTime +
                '}';
    }
}
