package com.xdja.pki.auditlog.dao.model;

import org.nutz.dao.entity.annotation.*;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName: AuditorOperateLogDO class
 * @Description: 审计员操作日志DO
 * @Author: songxuetao
 * @Version: v1.0.0
 **/
@Table("auditor_operate_log")
@Comment("审计员操作日志")
public class AuditorOperateLogDO implements Serializable {
    private static final long serialVersionUID = 1L;

    @Id
    @Column("id")
    @Comment("主键、自增")
    private Long id;

    @Column("audit_subject")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("审计员证书主体")
    private String auditSubject;

    @Column("audit_sn")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("审计员证书序列号")
    private String auditSn;

    @Column("audit_cert_id")
    @ColDefine(type = ColType.INT)
    @Comment("审计员证书ID")
    private Long auditCertId;

    @Column("audit_type")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("审计操作类型，对应字典表code字段`auditorOperateType`")
    private String auditType;

    @Column("audit_client_ip")
    @ColDefine(type = ColType.DATETIME)
    @Comment("审计客户端ip")
    private String auditClientIp;

    @Column("audit_content")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("审计内容")
    private String auditContent;

    @Column("audit_result")
    @ColDefine(type = ColType.INT)
    @Comment("操作结果，1-成功；2-失败")
    private Integer auditResult;

    @Column("gmt_create")
    @ColDefine(type = ColType.DATETIME)
    @Comment("创建时间")
    private Date auditTime;

    @Column("gmt_modified")
    @ColDefine(type = ColType.DATETIME)
    @Comment("修改时间")
    private Date auditModifyTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAuditSubject() {
        return auditSubject;
    }

    public void setAuditSubject(String auditSubject) {
        this.auditSubject = auditSubject;
    }

    public String getAuditSn() {
        return auditSn;
    }

    public void setAuditSn(String auditSn) {
        this.auditSn = auditSn;
    }

    public Long getAuditCertId() {
        return auditCertId;
    }

    public void setAuditCertId(Long auditCertId) {
        this.auditCertId = auditCertId;
    }

    public String getAuditType() {
        return auditType;
    }

    public void setAuditType(String auditType) {
        this.auditType = auditType;
    }

    public String getAuditClientIp() {
        return auditClientIp;
    }

    public void setAuditClientIp(String auditClientIp) {
        this.auditClientIp = auditClientIp;
    }

    public String getAuditContent() {
        return auditContent;
    }

    public void setAuditContent(String auditContent) {
        this.auditContent = auditContent;
    }

    public Integer getAuditResult() {
        return auditResult;
    }

    public void setAuditResult(Integer auditResult) {
        this.auditResult = auditResult;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public Date getAuditModifyTime() {
        return auditModifyTime;
    }

    public void setAuditModifyTime(Date auditModifyTime) {
        this.auditModifyTime = auditModifyTime;
    }
}
