package com.xdja.pki.auditlog.dao.model;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import org.nutz.dao.entity.annotation.*;

import java.io.Serializable;
import java.util.Date;

/**
 * 周期审计日志表实体
 */
@Table("period_audit_log")
@Comment("周期审计日志")
public class PeriodAuditLogDO implements Serializable {
    private static final Long serialVersionUID = 1L;

    @Id
    @Column("id")
    @Comment("主键、自增")
    private Long id;

    @Column("is_audit")
    @ColDefine(type = ColType.INT)
    @Comment("是否审核，1-未审核；2-已审核")
    private Integer isAudit;

    @Column("is_verify")
    @ColDefine(type = ColType.INT)
    @Comment("验签结果，1-签名不一致；2-签名一致")
    private Integer isVerify;

    @Column("sign_period_start")
    @ColDefine(type = ColType.DATETIME)
    @Comment("签名周期开始时间")
    private Date signPeriodStart;

    @Column("sign_period_end")
    @ColDefine(type = ColType.DATETIME)
    @Comment("签名周期结束时间")
    private Date signPeriodEnd;

    @Column("audit_log_sign")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("周期审计日志签名")
    private String auditLogSign;

    @Column("server_operator_sign")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("服务器操作签名")
    private String serverOperatorSign;

    @Column("server_cert_id")
    @ColDefine(type = ColType.INT)
    @Comment("服务器证书ID")
    private Long serverCertId;

    @Column("server_subject")
    @ColDefine(type = ColType.VARCHAR)
    @Comment("服务器证书主体")
    private String serverSubject;

    @Column("operate_result")
    @ColDefine(type = ColType.INT)
    @Comment("服务器签名结果，1-成功；2-失败")
    private Integer operateResult;

    @Column("gmt_create")
    @ColDefine(type = ColType.DATETIME)
    @Comment("操作时间")
    private Date operateTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getIsAudit() {
        return isAudit;
    }

    public void setIsAudit(Integer isAudit) {
        this.isAudit = isAudit;
    }

    public Integer getIsVerify() {
        return isVerify;
    }

    public void setIsVerify(Integer isVerify) {
        this.isVerify = isVerify;
    }

    public Date getSignPeriodStart() {
        return signPeriodStart;
    }

    public void setSignPeriodStart(Date signPeriodStart) {
        this.signPeriodStart = signPeriodStart;
    }

    public Date getSignPeriodEnd() {
        return signPeriodEnd;
    }

    public void setSignPeriodEnd(Date signPeriodEnd) {
        this.signPeriodEnd = signPeriodEnd;
    }

    public Long getServerCertId() {
        return serverCertId;
    }

    public void setServerCertId(Long serverCertId) {
        this.serverCertId = serverCertId;
    }

    public String getServerOperatorSign() {
        return serverOperatorSign;
    }

    public void setServerOperatorSign(String serverOperatorSign) {
        this.serverOperatorSign = serverOperatorSign;
    }

    public String getAuditLogSign() {
        return auditLogSign;
    }

    public void setAuditLogSign(String auditLogSign) {
        this.auditLogSign = auditLogSign;
    }

    public String getServerSubject() {
        return serverSubject;
    }

    public void setServerSubject(String serverSubject) {
        this.serverSubject = serverSubject;
    }

    public Integer getOperateResult() {
        return operateResult;
    }

    public void setOperateResult(Integer operateResult) {
        this.operateResult = operateResult;
    }

    public Date getOperateTime() {
        return operateTime;
    }

    public void setOperateTime(Date operateTime) {
        this.operateTime = operateTime;
    }

    @Override
    public String toString() {
        return "PeriodAuditLogDO{" +
                "id=" + id +
                ", isAudit=" + isAudit +
                ", isVerify=" + isVerify +
                ", signPeriodStart=" + signPeriodStart +
                ", signPeriodEnd=" + signPeriodEnd +
                ", auditLogSign='" + auditLogSign + '\'' +
                ", serverOperatorSign='" + serverOperatorSign + '\'' +
                ", serverCertId=" + serverCertId +
                ", serverSubject='" + serverSubject + '\'' +
                ", operateResult=" + operateResult +
                ", operateTime=" + operateTime +
                '}';
    }

    public String operatorBase64Encode() {
        String s = "PeriodAuditLogDO{" +
                " serverSubject='" + serverSubject + "\'" +
                ", signPeriodStart='" + signPeriodStart + "\'" +
                ", signPeriodEnd=" + signPeriodEnd +
                ", operateResult='" + operateResult + "\'" +
                ", auditLogSign='" + auditLogSign +
                "}";
        return GMSSLByteArrayUtils.base64Encode(s.getBytes());
    }
}
