package com.xdja.pki.auditlog.dao.model;

import org.nutz.dao.entity.annotation.*;

import java.io.Serializable;
import java.util.Date;

/**
 * 周期审计日志关联表实体
 */
@Table("period_audit_log_relation")
@Comment("周期审计日志关系表")
public class PeriodAuditLogRelationDO implements Serializable {
    private static final Long serialVersionUID = 1L;

    @Id
    @Column("id")
    @Comment("主键、自增")
    private Long id;

    @Column("period_log_id")
    @ColDefine(type = ColType.INT)
    @Comment("周期审计日志ID")
    private Long periodLogId;

    @Column("audit_log_id")
    @ColDefine(type = ColType.INT)
    @Comment("审计日志ID")
    private Long auditLogId;

    @Column("gmt_create")
    @ColDefine(type = ColType.DATETIME)
    @Comment("审计时间")
    private Date createTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPeriodLogId() {
        return periodLogId;
    }

    public void setPeriodLogId(Long periodLogId) {
        this.periodLogId = periodLogId;
    }

    public Long getAuditLogId() {
        return auditLogId;
    }

    public void setAuditLogId(Long auditLogId) {
        this.auditLogId = auditLogId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String toString() {
        return "PeriodAuditLogRelationDO{" +
                "id=" + id +
                ", periodLogId=" + periodLogId +
                ", auditLogId=" + auditLogId +
                ", createTime=" + createTime +
                '}';
    }
}
