package com.xdja.pki.auditlog.service;

import com.xdja.pki.core.bean.CoreResult;

/**
 * @ClassName: ArchiveLogService interface
 * @Description: TODO
 * @Author: songxuetao
 * @Modifiedby:
 * @Date: 2020/6/30 15:35
 * @Version: v1.0.0
 **/
public interface ArchiveLogService {
    /**
     * @MethodName: listArchiveLogs
     * @Description: 获取归档日志列表
     * @Param: pageNo
     * @Param: pageSize
     * @Param: operatorType
     * @Param: startTime
     * @Param: endTime
     * @param: isExport 是否是导出操作
     * @Return: java.lang.Object
     * @Author: songxuetao
    **/
    Object listArchiveLogs(Integer pageNo, Integer pageSize, Integer operatorType, String startTime, String endTime, boolean isExport);

    /**
     * @MethodName: getArchiveLogbyId
     * @Description: 获取归档日志详情
     * @Param: id
     * @Param: verify
     * @Return: java.lang.Object
     * @Author: songxuetao
    **/
    Object getArchiveLogbyId(int id, Integer verify);

    /**
     * @MethodName: verifyArchiveLog
     * @Description: 验签归档日志
     * @Param: id
     * @Return: com.xdja.pki.ca.core.common.CoreResult
     * @Author: songxuetao
    **/
    CoreResult verifyArchiveLog(int id);
}
