package com.xdja.pki.auditlog.service;

/**
 * @ClassName: AuditorOperateLogService interface
 * @Description: TODO
 * @Author: songxuetao
 **/
public interface AuditorOperateLogService {

    /**
     * @MethodName: saveAuditorOperateLog
     * @Description: 保存审计员操作信息方法
     * @Param: auditType 审计员操作类型
     * @Param: auditContext 审计员操作内容
     * @Param: auditResult 审计员操作结果
     * @Return: boolean 保存是否成功
     * @Author: songxuetao
    **/
    boolean saveAuditorOperateLog(int auditType, String auditContext, int auditResult);

    /**
     * @MethodName: listAuditorOperateLog
     * @Description: 获取审计员审计日志列表
     * @Param: pageNo 页码索引
     * @Param: pageSize 页数据量
     * @Param: auditSubject 审计员证书主体
     * @Param: auditType    审计员审计类型
     * @Param: startTime 开始时间
     * @Param: endTime  结束时间
     * @Param: isExport 是否是导出操作
     * @Return: java.lang.Object
     * @Author: songxuetao
    **/
    Object listAuditorOperateLog(Integer pageNo, Integer pageSize, String auditSubject, Integer auditType, String startTime, String endTime, boolean isExport);

    /**
     * @MethodName: getAuditorOperateLogById
     * @Description: 获取审计员审计日志详情
     * @Param: id
     * @Return: java.lang.Object
     * @Author: songxuetao
    **/
    Object getAuditorOperateLogById(int id);
}
