package com.xdja.pki.auditlog.service;

import com.xdja.pki.core.bean.CoreResult;

/**
 * @ClassName: PeriodAuditLogService interface
 * @Description: 周期审计日志接口
 * @Author: songxuetao
 * @Modifiedby:
 * @Date: 2020/11/19 14:43
 *  * @Version: v1.0.0
 **/
public interface PeriodAuditLogService {
    /**
     * 根据条件获取周期审计列表
     *
     * @param pageNo          页码
     * @param pageSize        每页个数
     * @param startTime       开始时间 过滤项
     * @param endTime         结束时间 过滤项
     * @return 列表对象
     */
    CoreResult getPeriodAuditLogList(Integer pageNo, Integer pageSize, String startTime, String endTime);

    /**
     * @MethodName: getAuditLogList
     * @Description: 分页获取周期内的审计日志
     * @Param: periodLogId
     * @Param: pageNo
     * @Param: pageSize
     * @Return: com.xdja.pki.core.bean.CoreResult
     * @Author: songxuetao
     * @ModifiedBy:
     * @Date: 2020/12/31 18:34
    **/
    CoreResult getAuditLogList(long periodLogId, Integer pageNo, Integer pageSize);

    /**
     * 周期审计日志验签
     *
     * @param id
     * @return
     */
    CoreResult verify(int id);


    CoreResult saveAndSignAuditLog(Integer period);

}
