package com.xdja.pki.auditlog.service.bean;

/**
 * 审计日志审核状态
 * 
 * @author sxy
 * @date 2019年4月14日
 *
 */
public enum AuditLogIsAuditEnum {

	/**
	 * 未审核
	 */
	FALSE(1, "未审核"),
	/**
	 * 已审核
	 */
	TRUE(2, "已审核");
	public int id;
	public String value;

	private AuditLogIsAuditEnum(int id, String value) {
		this.id = id;
		this.value = value;
	}

	public static String getValueFromId(int id){
		for (AuditLogIsAuditEnum t: AuditLogIsAuditEnum.values()) {
			if (t.id == id){
				return t.value;
			}
		}
		throw new IllegalArgumentException(String.format("AuditLogIsAuditEnum 枚举转换异常[id=%d]", id));
	}
}
