package com.xdja.pki.auditlog.service.bean;

/**
 * 审计日志验签状态
 * 
 * @author sxy
 * @date 2019年4月14日
 *
 */
public enum AuditLogIsVerifyEnum {

	/**
	 * 签名不一致
	 */
	FALSE(1, "签名不一致"),
	/**
	 * 签名一致
	 */
	TRUE(2, "签名一致");

	public int id;
	public String value;

	private AuditLogIsVerifyEnum(int id, String value) {
		this.id = id;
		this.value = value;
	}

	public static AuditLogIsVerifyEnum getInstance(boolean isVerify){
		if (isVerify){
			return TRUE;
		} else {
			return FALSE;
		}
	}

	public static String getValueFromId(int id){
		for (AuditLogIsVerifyEnum t: AuditLogIsVerifyEnum.values()) {
			if (t.id == id){
				return t.value;
			}
		}
		throw new IllegalArgumentException(String.format("AuditLogIsVerifyEnum 枚举转换异常[id=%d]", id));
	}
}
