package com.xdja.pki.auditlog.service.bean;


import com.xdja.pki.core.utils.file.ExcelCell;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * AuditLogListVO
 * 需要展示的数据
 */
public class AuditLogListVO {
    //证书主体  操作类型  客户端IP 操作时间 操作结果 审核状态
    private Long id;
    //证书主体
    @ExcelCell(title = "操作者证书主体", width = 30, isDate = false)
    private String operatorSubject;
    private String operatorType;
    //  操作类型
    @ExcelCell(title = "操作类型", width = 15, isDate = false)
    private String operatorTypeString;
    //客户端IP
    @ExcelCell(title = "操作客户端IP", width = 20, isDate = false)
    private String operateClientIp;
    private Integer operateResult;
    // 操作结果
    @ExcelCell(title = "操作结果", width = 10, isDate = false)
    private String operateResultString;

    private Integer isAudit;
    // 审核状态
    @ExcelCell(title = "审核状态", width = 10, isDate = false)
    private String isAuditString;
    @ExcelCell(title = "操作时间", width = 20, isDate = false)
    private String operateTime;

    private Integer isVerify;
    // 审核状态
    @ExcelCell(title = "验签状态", width = 10, isDate = false)
    private String isVerifyString;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOperatorSubject() {
        return operatorSubject;
    }

    public void setOperatorSubject(String operatorSubject) {
        this.operatorSubject = operatorSubject;
    }

    public String getOperatorType() {
        return operatorType;
    }

    public void setOperatorType(String operatorType) {
        this.operatorType = operatorType;
    }

    public String getOperatorTypeString() {
        return operatorTypeString;
    }

    public void setOperatorTypeString(String operatorTypeString) {
        this.operatorTypeString = operatorTypeString;
    }

    public String getOperateClientIp() {
        return operateClientIp;
    }

    public void setOperateClientIp(String operateClientIp) {
        this.operateClientIp = operateClientIp;
    }

    public Integer getOperateResult() {
        return operateResult;
    }

    public void setOperateResult(Integer operateResult) {
        this.operateResult = operateResult;
    }

    public String getOperateResultString() {
        return operateResultString;
    }

    public void setOperateResultString(String operateResultString) {
        this.operateResultString = operateResultString;
    }

    public String getIsAuditString() {
        return isAuditString;
    }

    public void setIsAuditString(String isAuditString) {
        this.isAuditString = isAuditString;
    }

    public String getIsVerifyString() {
        return isVerifyString;
    }

    public void setIsVerifyString(String isVerifyString) {
        this.isVerifyString = isVerifyString;
    }

    public Integer getIsVerify() {
        return isVerify;
    }

    public void setIsVerify(Integer isVerify) {
        this.isVerify = isVerify;
    }

    public String getOperateTime() {
        return operateTime;
    }

    public void setOperateTime(Date operateTime) {
        this.operateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(operateTime);
    }

    public Integer getIsAudit() {
        return isAudit;
    }

    public void setIsAudit(Integer isAudit) {
        this.isAudit = isAudit;
    }
}
