package com.xdja.pki.auditlog.service.bean;

/**
 * 审计日志结果枚举
 * 
 * @author sxy
 * @date 2019年4月14日
 *
 */
public enum AuditLogResultEnum {
	
	/**
	 * 成功
	 */
	SUCCESS(1, "成功"),
	/**
	 * 失败
	 */
	FAIL(2, "失败");

    public int id;
    public String value;

    private AuditLogResultEnum(int id, String value) {
        this.id = id;
        this.value = value;
    }

    public static String getValueFromId(int id){
        for (AuditLogResultEnum t: AuditLogResultEnum.values()) {
            if (t.id == id){
                return t.value;
            }
        }
        throw new IllegalArgumentException(String.format("AuditLogResultEnum 枚举转换异常[id=%d]", id));
    }
}
