package com.xdja.pki.auditlog.service.bean;

/**
 * @ClassName: AuditorOperateTypeEnum enum
 * @Description: 审计员操作类型枚举类
 * @Version: v1.0.0
 **/
public enum AuditorOperateTypeEnum {

    AUDIT_LOG(1, "审核日志"),
    ARCHIVE_LOG(2, "归档日志"),
    EXPORT_LOG(3, "导出日志"),
    VERIFY_LOG(4, "验签日志"),
    CONFIG_AUDIT_PARAMS(5, "审计参数配置");

    public int type;
    public String desc;

    private AuditorOperateTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getDescFromType(String type){
        for (AuditorOperateTypeEnum t: AuditorOperateTypeEnum.values()) {
            if (t.type == Integer.valueOf(type)){
                return t.desc;
            }
        }
        throw new IllegalArgumentException(String.format("AuditorOperateTypeEnum 枚举转换异常[type=%s]", type));
    }
}
