package com.xdja.pki.auditlog.service.bean;


import com.xdja.pki.core.utils.file.ExcelCell;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * AuditLogListVO
 * 需要展示的数据
 */
public class PeriodAuditLogListVO {
    //证书主体  操作类型  客户端IP 操作时间 操作结果 审核状态
    private Long id;
    //证书主体
    @ExcelCell(title = "服务器证书主体", width = 30, isDate = false)
    private String serverSubject;

    private Integer operateResult;
    // 操作结果
    @ExcelCell(title = "操作结果", width = 10, isDate = false)
    private String operateResultString;

    @ExcelCell(title = "操作时间", width = 20, isDate = false)
    private String operateTime;

    @ExcelCell(title = "周期开始时间", width = 20, isDate = false)
    private String signPeriodStart;

    @ExcelCell(title = "周期结束时间", width = 20, isDate = false)
    private String signPeriodEnd;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getOperateResult() {
        return operateResult;
    }

    public void setOperateResult(Integer operateResult) {
        this.operateResult = operateResult;
    }

    public String getOperateResultString() {
        return operateResultString;
    }

    public void setOperateResultString(String operateResultString) {
        this.operateResultString = operateResultString;
    }

    public String getOperateTime() {
        return operateTime;
    }

    public void setOperateTime(Date operateTime) {
        this.operateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(operateTime);
    }

    public String getServerSubject() {
        return serverSubject;
    }

    public void setServerSubject(String serverSubject) {
        this.serverSubject = serverSubject;
    }

    public String getSignPeriodStart() {
        return signPeriodStart;
    }

    public void setSignPeriodStart(Date signPeriodStart) {
        this.signPeriodStart =  new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(signPeriodStart);
    }

    public String getSignPeriodEnd() {
        return signPeriodEnd;
    }

    public void setSignPeriodEnd(Date signPeriodEnd) {
        this.signPeriodEnd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(signPeriodEnd);
    }
}
