package com.xdja.pki.auditlog.service.bean.ca;

/**
 * 审计日志操作类型枚举
 *
 * @author sxy
 * @date 2019年4月14日
 */
public enum AuditLogOperatorTypeEnum {

    /**
     * 审计日志类型
     */
    SYSTEM_LOGIN(1, "登录登出"),
    P10_GENERATE(2, "生成申请书"),
    CERT_IMPORT(3, "导入证书"),
    CERT_SIGN(4, "签发证书"),
    CERT_UPDATE(5, "更新证书"),
    CERT_REVOKED(6, "撤销证书"),
    CERT_DOWNLOAD(7, "下载证书"),
    TEMPLATE_MANAGER(8, "模板管理"),
    RA_MANAGER(9, "RA管理"),
    SUB_CA_MANAGER(10, "下级CA管理"),
    SYSTEM_CONFIG_UPDATE(11, "修改系统配置"),
    CERT_REEZE(12,"冻结证书"),
    CERT_UNFREEZE(13,"解冻证书"),
    CERT_ARCHIVE(14, "证书归档"),
    CERT_RESUME(15, "证书恢复"),
    CRL_TEMPLATE_MANAGEMENT(16, "CRL模板管理"),
    CUSTOMIZE_EXTENSION(17,"自定义扩展域"),
    SYSTEM_BACKUP_MANAGEMENT(100, "系统备份管理");

    public int type;
    public String desc;

    private AuditLogOperatorTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getDescFromType(String type){
        for (AuditLogOperatorTypeEnum t: AuditLogOperatorTypeEnum.values()) {
            if (t.type == Integer.valueOf(type)){
                return t.desc;
            }
        }
        throw new IllegalArgumentException(String.format("AuditLogOperatorTypeEnum 枚举转换异常[type=%s]", type));
    }
}
