package com.xdja.pki.auditlog.service.bean.ra;

/**
 * 审计日志操作类型枚举
 */
public enum AuditLogOperatorTypeEnum {

    SYSTEM_LOGIN(1, "登录登出"),
    SUBMIT_APPLY(2, "申请提交"),
    UPDATE_APPLY(3, "申请修改"),
    AUDIT_APPLY(4, "申请审核"),
    CERT_ISSUE(5, "签发证书"),
    CERT_UPDATE(6, "更新证书"),
    CERT_REVOKED(7, "撤销证书"),
    CERT_DOWNLOAD(8, "下载证书"),
    TEMPLATE_MANAGER(9, "模板管理"),
    USER_MANAGER(10, "用户管理"),
    SYSTEM_CONFIG_UPDATE(11, "修改系统配置"),
    //CERT_RESUME(12, "恢复证书"),
    THIRD_PARTY_SYSTEM(13, "第三方系统管理"),
    SYSTEM_BACKUP_MANAGEMENT(100, "系统备份管理");

    public int type;
    public String desc;

    private AuditLogOperatorTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getDescFromType(String type) {
        for (AuditLogOperatorTypeEnum t : AuditLogOperatorTypeEnum.values()) {
            if (t.type == Integer.valueOf(type)) {
                return t.desc;
            }
        }
        throw new IllegalArgumentException(String.format("AuditLogOperatorTypeEnum 枚举转换异常[type=%s]", type));
    }
}
