package com.xdja.pki.auditlog.service.thread;

import com.xdja.pki.auditlog.service.PeriodAuditLogService;
import com.xdja.pki.core.utils.SpringBeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;

/**
 * @ClassName: PeriodAuditLogThread class
 * @Description: TODO
 **/
public class PeriodAuditLogThread implements Runnable{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private Integer auditLogPeriod;

    public PeriodAuditLogThread(){}

    public PeriodAuditLogThread(Integer periodTime){
        this.auditLogPeriod = periodTime;
    }

    @Override
    public void run() {
        if(logger.isDebugEnabled()) {
            logger.debug("系统周期性审计日志开始》》》》》， 周期为 {} 小时", auditLogPeriod);
        }
        PeriodAuditLogService periodAuditLogService = SpringBeanUtils.getBean(PeriodAuditLogService.class);
        try{
            periodAuditLogService.saveAndSignAuditLog(auditLogPeriod);
        }catch (Exception e){
            logger.error("系统周期性审计日志异常", e);
        }
        if(logger.isDebugEnabled()) {
            logger.debug("系统周期性审计日志结束》》》》》， 周期为 {} 小时", auditLogPeriod);
        }
    }
}
