/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.auditlog.dao;

import com.alibaba.druid.util.StringUtils;
import com.xdja.pki.auditlog.dao.model.AuditLogDO;
import com.xdja.pki.auditlog.dao.model.AuditLogListDO;
import com.xdja.pki.core.bean.PageInfo;
import com.xdja.pki.core.exception.DAOException;
import com.xdja.pki.core.utils.DateUtils;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.Collection;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class AuditLogDao
extends BaseJdbcDao {
    @Value(value="${system.database.type}")
    private int databaseType;

    public AuditLogDO saveLog(AuditLogDO logDO) {
        return (AuditLogDO)this.daoTemplate.insert((Object)logDO);
    }

    public AuditLogDO getLogById(int id) {
        Cnd cnd = Cnd.where((String)"id", (String)"=", (Object)id);
        cnd.orderBy("gmt_create", "desc");
        try {
            List list = this.daoTemplate.query(AuditLogDO.class, (Condition)cnd);
            if (list.size() != 1) {
                throw new DAOException("\u6839\u636eID\u83b7\u53d6\u5230:" + list.size() + "\u4e2a\u6570\u636e!");
            }
            return (AuditLogDO)list.get(0);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eid\u67e5\u8be2\u5ba1\u8ba1\u65e5\u5fd7\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int updateLog(AuditLogDO logDO) {
        return this.daoTemplate.update((Object)logDO);
    }

    public AuditLogDO get(int id) {
        Cnd cnd = Cnd.where((String)"id", (String)"=", (Object)id);
        cnd.orderBy("gmt_create", "desc");
        try {
            List list = this.daoTemplate.query(AuditLogDO.class, (Condition)cnd);
            if (list.size() != 1) {
                throw new DAOException("\u6839\u636eID\u83b7\u53d6\u5230:" + list.size() + "\u4e2a\u6570\u636e!");
            }
            return (AuditLogDO)list.get(0);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eid\u67e5\u8be2\u5ba1\u8ba1\u65e5\u5fd7\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<AuditLogDO> getAuditLogListbyPeriod(String startTime, String endTime) {
        Cnd cnd = Cnd.NEW();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)startTime) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)endTime)) {
            cnd.and("gmt_create", ">=", (Object)startTime);
            cnd.and("gmt_create", "<=", (Object)endTime);
        }
        cnd.orderBy("id", "desc");
        try {
            return this.daoTemplate.query(AuditLogDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u5206\u9875\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u5217\u8868\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public Object getLogList(Integer pageNo, Integer pageSize, String operatorSubject, Integer operatorType, Integer isAudit, String startTime, String endTime) {
        Cnd cnd = Cnd.NEW();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)operatorSubject)) {
            cnd.and("operator_subject", "LIKE", (Object)("%" + operatorSubject + "%"));
        }
        if (null != operatorType) {
            cnd.and("operator_type", "=", (Object)operatorType);
        }
        if (null != isAudit) {
            cnd.and("is_audit", "=", (Object)isAudit);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)startTime) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)endTime)) {
            startTime = DateUtils.getDbTime((int)this.databaseType, (String)(startTime + " 00:00:00 "));
            endTime = DateUtils.getDbTime((int)this.databaseType, (String)(endTime + " 23:59:59 "));
            cnd.and("gmt_create", ">=", (Object)startTime);
            cnd.and("gmt_create", "<=", (Object)endTime);
        }
        cnd.orderBy("id", "desc");
        try {
            if (pageNo == 0 && pageSize == 0) {
                return this.daoTemplate.query(AuditLogListDO.class, (Condition)cnd);
            }
            PageInfo pageInfo = new PageInfo(pageNo.intValue(), pageSize.intValue(), this.daoTemplate.count(AuditLogListDO.class, (Condition)cnd));
            pageInfo.setDatas((Collection)this.daoTemplate.query(AuditLogListDO.class, (Condition)cnd, this.createPager(pageNo, pageSize)));
            this.logger.debug("list page info {} ", (Object)pageInfo);
            return pageInfo;
        }
        catch (Exception e) {
            throw new DAOException("\u5206\u9875\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u5217\u8868\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public Object archiveList(String operatorSubject, Integer operatorType, Integer isAudit, String startTime, String endTime) {
        Cnd cnd = Cnd.NEW();
        if (!StringUtils.isEmpty((String)operatorSubject)) {
            cnd.and("operator_subject", "LIKE", (Object)("%" + operatorSubject + "%"));
        }
        if (null != operatorType) {
            cnd.and("operator_type", "=", (Object)operatorType);
        }
        if (null != isAudit) {
            cnd.and("is_audit", "=", (Object)isAudit);
        }
        if (!StringUtils.isEmpty((String)startTime) && !StringUtils.isEmpty((String)endTime)) {
            startTime = DateUtils.getDbTime((int)this.databaseType, (String)(startTime + " 00:00:00 "));
            endTime = DateUtils.getDbTime((int)this.databaseType, (String)(endTime + " 23:59:59 "));
            cnd.and("gmt_create", ">", (Object)startTime);
            cnd.and("gmt_create", "<", (Object)endTime);
        }
        try {
            return this.daoTemplate.query(AuditLogDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u624b\u52a8\u5f52\u6863\u67e5\u8be2\u5ba1\u8ba1\u65e5\u5fd7\u5217\u8868\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int getTotalRecords() {
        return this.daoTemplate.count(AuditLogDO.class);
    }

    public int getOverAuditRecordNum(String compareTime) {
        Cnd cnd = Cnd.NEW();
        cnd.and("is_audit", "=", (Object)1);
        compareTime = DateUtils.getDbTime((int)this.databaseType, (String)(compareTime + " 00:00:00"));
        cnd.and("gmt_create", "<", (Object)compareTime);
        return this.daoTemplate.count(AuditLogDO.class, (Condition)cnd);
    }

    public Object autoArchiveList(String compareTime) {
        Cnd cnd = Cnd.NEW();
        cnd.and("gmt_create", "<", (Object)compareTime);
        try {
            return this.daoTemplate.query(AuditLogDO.class, (Condition)cnd);
        }
        catch (Exception e) {
            throw new DAOException("\u81ea\u52a8\u5f52\u6863\u67e5\u8be2\u5ba1\u8ba1\u65e5\u5fd7\u5217\u8868\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int deleteAuditLogList(List<AuditLogDO> auditLogDOS) {
        return this.daoTemplate.delete(auditLogDOS);
    }
}

