/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.auditlog.dao;

import com.alibaba.druid.util.StringUtils;
import com.xdja.pki.auditlog.dao.model.ArchiveLogDO;
import com.xdja.pki.core.bean.PageInfo;
import com.xdja.pki.core.exception.DAOException;
import com.xdja.pki.core.utils.DateUtils;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.Collection;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class ArchiveLogDao
extends BaseJdbcDao {
    @Value(value="${system.database.type}")
    private int databaseType;

    public Object listArchiveLog(Integer pageNo, Integer pageSize, Integer operatorType, String startTime, String endTime, boolean isExport) {
        Cnd cnd = Cnd.NEW();
        if (null != operatorType) {
            cnd.and("operator_type", "=", (Object)operatorType);
        }
        if (!StringUtils.isEmpty((String)startTime) && !StringUtils.isEmpty((String)endTime)) {
            startTime = DateUtils.getDbTime((int)this.databaseType, (String)(startTime + " 00:00:00 "));
            endTime = DateUtils.getDbTime((int)this.databaseType, (String)(endTime + " 23:59:59 "));
            cnd.and("gmt_create", ">", (Object)startTime);
            cnd.and("gmt_create", "<", (Object)endTime);
        }
        cnd.orderBy("archive_create", "desc");
        try {
            if (isExport) {
                return this.daoTemplate.query(ArchiveLogDO.class, (Condition)cnd);
            }
            PageInfo pageInfo = new PageInfo(pageNo.intValue(), pageSize.intValue(), this.daoTemplate.count(ArchiveLogDO.class, (Condition)cnd));
            pageInfo.setDatas((Collection)this.daoTemplate.query(ArchiveLogDO.class, (Condition)cnd, this.createPager(pageNo, pageSize)));
            this.logger.debug("list page info {} ", (Object)pageInfo);
            return pageInfo;
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2\u5f52\u6863\u65e5\u5fd7\u5217\u8868\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public ArchiveLogDO get(int id) {
        Cnd cnd = Cnd.where((String)"id", (String)"=", (Object)id);
        try {
            List archiveLogDOS = this.daoTemplate.query(ArchiveLogDO.class, (Condition)cnd);
            if (archiveLogDOS.size() != 1) {
                throw new DAOException("\u6839\u636eID\u83b7\u53d6\u5230:" + archiveLogDOS.size() + "\u4e2a\u6570\u636e!");
            }
            return (ArchiveLogDO)archiveLogDOS.get(0);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eid\u67e5\u8be2\u5ba1\u8ba1\u65e5\u5fd7\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int saveArchiveLogList(List<ArchiveLogDO> archiveLogDOList) {
        return ((List)this.daoTemplate.insert(archiveLogDOList)).size();
    }
}

